
package ohd.hseb.util.fews.xmlconfigfiles;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Burn-in profile for cold state starts. Used to replace first part of a time series.
 * 
 * For time series with matching parameter-location ids, the first value is replaced by the initialValue. Element length defines the length of time series beginning that is to be replaced using linear interpolation. 
 * 
 * <p>Java class for BurnInProfileComplexType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="BurnInProfileComplexType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="length" type="{http://www.wldelft.nl/fews}TimeSpanComplexType"/>
 *         &lt;element name="timeSeries" type="{http://www.wldelft.nl/fews}BurnInProfileTimeSeriesComplexType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BurnInProfileComplexType", propOrder = {
    "length",
    "timeSeries"
})
public class BurnInProfileComplexType {

    @XmlElement(required = true)
    protected TimeSpanComplexType length;
    protected List<BurnInProfileTimeSeriesComplexType> timeSeries;

    /**
     * Gets the value of the length property.
     * 
     * @return
     *     possible object is
     *     {@link TimeSpanComplexType }
     *     
     */
    public TimeSpanComplexType getLength() {
        return length;
    }

    /**
     * Sets the value of the length property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeSpanComplexType }
     *     
     */
    public void setLength(TimeSpanComplexType value) {
        this.length = value;
    }

    /**
     * Gets the value of the timeSeries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeSeries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeSeries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BurnInProfileTimeSeriesComplexType }
     * 
     * 
     */
    public List<BurnInProfileTimeSeriesComplexType> getTimeSeries() {
        if (timeSeries == null) {
            timeSeries = new ArrayList<BurnInProfileTimeSeriesComplexType>();
        }
        return this.timeSeries;
    }

}
