
package ohd.hseb.util.fews.xmlconfigfiles;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for gridPlotArrowSymbolEnumStringType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="gridPlotArrowSymbolEnumStringType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="flow"/>
 *     &lt;enumeration value="wind"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "gridPlotArrowSymbolEnumStringType")
@XmlEnum
public enum GridPlotArrowSymbolEnumStringType {


    /**
     * Flow arrow symbol (-->). These arrows are centered at the location corresponding to the data point (e.g. centered at cell center)
     * 
     */
    @XmlEnumValue("flow")
    FLOW("flow"),

    /**
     * Wind arrow symbol (>). These arrows start at the location corresponding to the data point (e.g. start at cell center)	
     * 
     */
    @XmlEnumValue("wind")
    WIND("wind");
    private final String value;

    GridPlotArrowSymbolEnumStringType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static GridPlotArrowSymbolEnumStringType fromValue(String v) {
        for (GridPlotArrowSymbolEnumStringType c: GridPlotArrowSymbolEnumStringType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
