
package ohd.hseb.util.fews.xmlconfigfiles;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;


/**
 * Defines a moving period in time. The start and end time are relative time to a certain time.
 *                 When the start time is not specified it is determined by the start time of the state of the current
 *                 run.
 *                 When the start is overrulable the time is overruled by the start of search period or the start of cold
 *                 state run when one of two is specified
 *                 When the end is overrulable this time is overruled by the end of the forecast when
 *                 specified
 * 
 * <p>Java class for TimeSeriesSetRelativePeriodComplexType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="TimeSeriesSetRelativePeriodComplexType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="unit" use="required" type="{http://www.wldelft.nl/fews}timeUnitEnumStringType" />
 *       &lt;attribute name="start" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="end" use="required" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="startOverrulable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="endOverrulable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TimeSeriesSetRelativePeriodComplexType", propOrder = {
    "description"
})
public class TimeSeriesSetRelativePeriodComplexType {

    protected String description;
    @XmlAttribute(required = true)
    protected TimeUnitEnumStringType unit;
    @XmlAttribute
    protected Integer start;
    @XmlAttribute(required = true)
    protected int end;
    @XmlAttribute
    protected Boolean startOverrulable;
    @XmlAttribute
    protected Boolean endOverrulable;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the unit property.
     * 
     * @return
     *     possible object is
     *     {@link TimeUnitEnumStringType }
     *     
     */
    public TimeUnitEnumStringType getUnit() {
        return unit;
    }

    /**
     * Sets the value of the unit property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeUnitEnumStringType }
     *     
     */
    public void setUnit(TimeUnitEnumStringType value) {
        this.unit = value;
    }

    /**
     * Gets the value of the start property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getStart() {
        return start;
    }

    /**
     * Sets the value of the start property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setStart(Integer value) {
        this.start = value;
    }

    /**
     * Gets the value of the end property.
     * 
     */
    public int getEnd() {
        return end;
    }

    /**
     * Sets the value of the end property.
     * 
     */
    public void setEnd(int value) {
        this.end = value;
    }

    /**
     * Gets the value of the startOverrulable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isStartOverrulable() {
        if (startOverrulable == null) {
            return false;
        } else {
            return startOverrulable;
        }
    }

    /**
     * Sets the value of the startOverrulable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setStartOverrulable(Boolean value) {
        this.startOverrulable = value;
    }

    /**
     * Gets the value of the endOverrulable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEndOverrulable() {
        if (endOverrulable == null) {
            return false;
        } else {
            return endOverrulable;
        }
    }

    /**
     * Sets the value of the endOverrulable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setEndOverrulable(Boolean value) {
        this.endOverrulable = value;
    }

}
