
package ohd.hseb.util.fews.xmlconfigfiles;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for timeZoneEnumStringType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="timeZoneEnumStringType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="GMT"/>
 *     &lt;enumeration value="MIT"/>
 *     &lt;enumeration value="HST"/>
 *     &lt;enumeration value="AST"/>
 *     &lt;enumeration value="PST"/>
 *     &lt;enumeration value="MST"/>
 *     &lt;enumeration value="PNT"/>
 *     &lt;enumeration value="CST"/>
 *     &lt;enumeration value="EST"/>
 *     &lt;enumeration value="IET"/>
 *     &lt;enumeration value="PRT"/>
 *     &lt;enumeration value="CNT"/>
 *     &lt;enumeration value="AGT"/>
 *     &lt;enumeration value="BET"/>
 *     &lt;enumeration value="WET"/>
 *     &lt;enumeration value="CET"/>
 *     &lt;enumeration value="MET"/>
 *     &lt;enumeration value="CAT"/>
 *     &lt;enumeration value="EET"/>
 *     &lt;enumeration value="EAT"/>
 *     &lt;enumeration value="AZT"/>
 *     &lt;enumeration value="NET"/>
 *     &lt;enumeration value="PLT"/>
 *     &lt;enumeration value="IST"/>
 *     &lt;enumeration value="BST"/>
 *     &lt;enumeration value="VST"/>
 *     &lt;enumeration value="PRC"/>
 *     &lt;enumeration value="JST"/>
 *     &lt;enumeration value="ROK"/>
 *     &lt;enumeration value="ACT"/>
 *     &lt;enumeration value="AET"/>
 *     &lt;enumeration value="SST"/>
 *     &lt;enumeration value="NST"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "timeZoneEnumStringType")
@XmlEnum
public enum TimeZoneEnumStringType {

    GMT,

    /**
     * West Samoa Time, winter and summer:GMT-11
     * 
     */
    MIT,

    /**
     * Hawaii Standard Time, winter and summer:GMT-10
     * 
     */
    HST,

    /**
     * Alaska Standard Time, winter:GMT-9 summer:GMT-8
     * 
     */
    AST,

    /**
     * Pacific Standard Time, winter:GMT-8 summer:GMT-7
     * 
     */
    PST,

    /**
     * Mountain Standard Time, winter and summer:GMT-7
     * 
     */
    MST,

    /**
     * Mountain Standard Time, winter and summer:GMT-7
     * 
     */
    PNT,

    /**
     * Central Standard Time, winter:GMT-6 summer:GMT-5
     * 
     */
    CST,

    /**
     * Eastern Standard Time, winter and summer:GMT-5
     * 
     */
    EST,

    /**
     * Eastern Standard Time, winter:GMT-5 summer:GMT-4
     * 
     */
    IET,

    /**
     * Atlantic Standard Time, winter and summer:GMT-4
     * 
     */
    PRT,

    /**
     * Newfoundland Standard Time, winter:GMT-3:30 summer:GMT-2:30
     * 
     */
    CNT,

    /**
     * Argentine Time, winter:GMT-3 summer:GMT-2
     * 
     */
    AGT,

    /**
     * Brasilia Time, winter:GMT-3 summer:GMT-2
     * 
     */
    BET,

    /**
     * Western European Time, winter:GMT+0 summer:GMT+1
     * 
     */
    WET,

    /**
     * Central European Time, winter:GMT+1 summer:GMT+2
     * 
     */
    CET,

    /**
     * Middle Europe Time, winter:GMT+1 summer:GMT+2
     * 
     */
    MET,

    /**
     * Central African Time, winter and summer:GMT+2
     * 
     */
    CAT,

    /**
     * Eastern European Time, winter:GMT+2 summer:GMT+3
     * 
     */
    EET,

    /**
     * Eastern African Time, winter and summer:GMT+3
     * 
     */
    EAT,

    /**
     * Azerbaijan Time, winter:GMT+4 summer:GMT+5
     * 
     */
    AZT,

    /**
     * Armenia Time, winter:GMT+4 summer:GMT+5
     * 
     */
    NET,

    /**
     * Pakistan Time, winter and summer:GMT+5
     * 
     */
    PLT,

    /**
     * India Standard Time, winter and summer:GMT+5:30
     * 
     */
    IST,

    /**
     * Bangladesh Time, winter and summer:GMT+6
     * 
     */
    BST,

    /**
     * Indochina Time, winter and summer:GMT+7
     * 
     */
    VST,

    /**
     * China Standard Time, winter and summer:GMT+8
     * 
     */
    PRC,

    /**
     * Japan Standard Time, winter and summer:GMT+9
     * 
     */
    JST,

    /**
     * Korea Standard Time, winter and summer:GMT+9
     * 
     */
    ROK,

    /**
     * Central Standard Time (Northern Territory), winter and summer:GMT+9:30
     * 					
     * 
     */
    ACT,

    /**
     * Eastern Standard Time (New South Wales), winter:GMT+10 summer:GMT+11
     * 
     */
    AET,

    /**
     * Solomon Is. Time, winter and summer:GMT+11
     * 
     */
    SST,

    /**
     * New Zealand Standard Time, winter:GMT+12 summer:GMT+13
     * 
     */
    NST;

    public String value() {
        return name();
    }

    public static TimeZoneEnumStringType fromValue(String v) {
        return valueOf(v);
    }

}
