
package ohd.hseb.util.fews.xmlconfigfiles;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for wmsImageFormatStringType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="wmsImageFormatStringType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="jpg"/>
 *     &lt;enumeration value="png"/>
 *     &lt;enumeration value="gif"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "wmsImageFormatStringType")
@XmlEnum
public enum WmsImageFormatStringType {


    /**
     * 
     * 						Default, choose this format for photos
     * 					
     * 
     */
    @XmlEnumValue("jpg")
    JPG("jpg"),

    /**
     * 
     * 						Format suitable for rendered maps with a distinct number of colors
     * 					
     * 
     */
    @XmlEnumValue("png")
    PNG("png"),

    /**
     * 
     * 						Format suitable for rendered maps with a distinct number of colors
     * 					
     * 
     */
    @XmlEnumValue("gif")
    GIF("gif");
    private final String value;

    WmsImageFormatStringType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static WmsImageFormatStringType fromValue(String v) {
        for (WmsImageFormatStringType c: WmsImageFormatStringType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
