package ohd.hseb.util.io;

/***********************************************************************************************************************
 * ********* COPYRIGHT Ac, 2006, RAYTHEON COMPANY ALL RIGHTS RESERVED, An Unpublished Work RAYTHEON PROPRIETARY If the
 * end user is not the U.S. Government or any agency thereof, use or disclosure of data contained in this source code
 * file is subject to the proprietary restrictions set forth in the Master Rights File. U.S. GOVERNMENT PURPOSE RIGHTS
 * NOTICE If the end user is the U.S. Government or any agency thereof, this source code is provided to the U.S.
 * Government with Government Purpose Rights. Use or disclosure of data contained in this source code file is subject to
 * the "Government Purpose Rights" restriction in the Master Rights File. U.S. EXPORT CONTROLLED TECHNICAL DATA Use or
 * disclosure of data contained in this source code file is subject to the export restrictions set forth in the Master
 * Rights File. *******************************************************************************
 **********************************************************************************************************************/

/**
 * <pre>
 * SOFTWARE HISTORY
 * Date         Ticket#         Engineer        Description
 * ------------ ----------      -----------     --------------------------
 * 09August2006 17                      Phillippe       Initial Creation
 * </pre>
 * 
 * @author bphillip
 * @version 1
 */

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

final public class StreamHandler
{

    /** The input stream being monitored */
    InputStream inStream;

    /**
     * A record of the data passing through the stream
     */
    String output;
    Object obj;

    /**
     * StreamHandler Constructor
     * 
     * @param is - the input stream to be monitored
     */
    public StreamHandler(final InputStream is, final Object inputObj)
    {
        this.inStream = is;
        output = "";
        obj = inputObj;
    }

    /**
     * Continuously samples a stream and records its contents.
     */
    public void run() throws IOException
    {
        final InputStreamReader inStreamReader = new InputStreamReader(inStream);
        final BufferedReader in = new BufferedReader(inStreamReader);

        try
        {
            String line = "";
            while((line = in.readLine()) != null)
            {
                output += line + "\n";
            }
        }
        catch(final IOException e)
        {
            throw e;
        }
        finally
        {
            in.close();
            inStreamReader.close();
        }

    }

    /**
     * Retrieves the data that has passed through the stream since monitoring began.
     * 
     * @return - The contents of the stream
     */
    public String getOutput()
    {
        return output;
    }
}
