package ohd.hseb.util.misc;

import ohd.hseb.db.Database;

public abstract class ArchiveDbTools
{

    final static String CLASSNAME = "ArchiveDbTools";

    //This string can be used to determine if the PE is for a paired value (see
    //computeRawTableName below).
    public final static String PAIRED_VALUE_PES = "HQ,MD,MN,MS,MV,NO,ST,TB,TE,TV";
    public final static String PECRSEP_DURS = "I,U,C,J,H,B,T,F,Q";

    //This stores the global archive database.
    public static ArchiveDatabaseController ADB_CTL;

    ////////////////////////////////////////////////////
    //Attributes
    ////////////////////////////////////////////////////

    ////////////////////////////////////////////////////
    //Static
    ////////////////////////////////////////////////////

    //Return the name of the raw data table to use based on a PEDTSEP.
    //null will be returned only if the passed in pedtsep is invalid (i.e.
    //not seven characters... this is the only check I do).
    public static String computeRawTableName(String pedtsep)
    {
        //The pedtsep must be EXACTLY 7 characters!
        if(pedtsep.length() != 7)
        {
            return null;
        }

        //Acquire the individual components for easy ref.
        String pe = pedtsep.toUpperCase().substring(0, 2); //Chars 0 and 1
        char dur = pedtsep.toUpperCase().charAt(2); //Char 2
        String ts = pedtsep.toUpperCase().substring(3, 5); //Chars 3 and 4
        char ext = pedtsep.toUpperCase().charAt(5); //Char 5
//        char prob = pedtsep.toUpperCase().charAt(6);       //Char 6

        //Get the apps-defaults token for adb_shef_raw_storall .
        String _storeAllToken = MiscTools.getAppsDefaults("adb_shef_raw_storall");
        if(_storeAllToken == null)
        {
            Messenger.writeMsg(Messenger.EVT_PARAMETERS + Messenger.TIER_1,
                               "Apps-defaults token adb_shef_raw_storal is not found.\n");
        }

        //If the PE implies a paired value type, then return pairedvalue.
        if((ArchiveDbTools.PAIRED_VALUE_PES.indexOf(pe) >= 0)
            && (ArchiveDbTools.PAIRED_VALUE_PES.indexOf(pe) < ArchiveDbTools.PAIRED_VALUE_PES.length()))
        {
            return "pairedvalues";
        }

        //If the type in contigency, then return pedcsep.
        if(ts.charAt(0) == 'C')
        {
            return "pedcsep";
        }

        //If the type is forecast, then return pedfsep.
        if(ts.charAt(0) == 'F')
        {
            return "pedfsep";
        }

        //If the duration is D or P or the extremum is NOT Z, then return pedrsep.
        if((dur == 'D') || (dur == 'P') || (ext != 'Z'))
        {
            return "pedrsep";
        }

        //If the duration is within PECRSEP_DURS and the type is R, then return
        //pecrsep or peirsep depending if the token adb_shef_raw_storall is OFF or ON. 
        if((ArchiveDbTools.PECRSEP_DURS.indexOf("" + dur) >= 0)
            && (ArchiveDbTools.PECRSEP_DURS.indexOf("" + dur) < ArchiveDbTools.PECRSEP_DURS.length())
            && (ts.charAt(0) == 'R'))
        {
            if(_storeAllToken.equals("OFF"))
            {
                return "pecrsep";
            }
            else
            {
                return "peirsep";
            }
        }
        //Return peoosep table.
        return "peoosep";
    }

    /**
     * This assumes that the Thread.currentThread().getName() is the naming scheme used for connection identifiers
     * within the ADB_CTL.
     * 
     * @param url
     */
    public static void createAdbCtlAndDefaultConnection(String url)
    {
        ArchiveDbTools.ADB_CTL = new ArchiveDatabaseController();
        ArchiveDbTools.ADB_CTL.createDatabaseConnection(Thread.currentThread().getName(), url);
    }

    /**
     * Disconnect the database.
     * 
     * @param args
     */
    public static void disconnectFromDatabase()
    {
        Database db = ArchiveDbTools.ADB_CTL.getConnection(Thread.currentThread().getName());
        db.disconnect();
    }

    /**
     * Remove all ADB_CTL entries.
     * 
     * @param args
     */
    public static void disconnectFromAllDatabases()
    {
        if(ArchiveDbTools.ADB_CTL != null)
        {
            ArchiveDbTools.ADB_CTL.removeAllConnections();
        }
    }

    /////////////////////////////////////////////////////////////////////////
    //A test main.  
    /////////////////////////////////////////////////////////////////////////
    public static void main(String args[])
    {

        //HERE are some tests:
        if(args.length != 1)
        {
            System.out.println("");
            System.out.println("The program returns the adb table for a pedtsep. ");
            System.out.println("Proper usage is: ");
            System.out.println("    <prog> <pedtsep>");
            System.out.println("");
            return;
        }

        System.out.println("");
        System.out.println("The passed pedtsep is: \"" + args[0] + "\".");
        System.out.println("The table name is: \"" + ArchiveDbTools.computeRawTableName(args[0]) + "\".");
        System.out.println("");

    }
}
