/*
 * Created on Sep 5, 2007 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.util.misc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HBinaryOutputStream extends DataOutputStream
{
    final public static String CLASSNAME = "HBinaryInputStream";

    //Static vars
    final public static int FLOAT_SIZE = 4;
    final public static int DOUBLE_SIZE = 8;
    final public static int SHORT_SIZE = 2;
    final public static int INT_SIZE = 4;
    final public static int LONG_SIZE = 8;

    //Flags to pass in to the setEndianFlag routine.  
    final public static boolean LITTLE_ENDIAN_DATA_FLAG = true;
    final public static boolean BIG_ENDIAN_DATA_FLAG = false;

    boolean _reversebytesflag; //If this is true, then reverse the bytes before processing.

    /**
     * This is the default constructor and will just call super followed by something to set the reversebytesflag if
     * necessary.
     * 
     * @param in InputStream to serve as base for this object.
     */
    public HBinaryOutputStream(final OutputStream out)
    {
        //Call the constructor for the super class.
        super(out);

        //Set the flag to determine if endians are to be swapped.
        //Here, I should read an environment variable or an apps-defaults token in order
        //to determine if I am on a linux system.  The default value is...
        _reversebytesflag = false; //True is for linux runs

        //Get the system property sun.cpu.endian.
        final String endian = System.getProperty("sun.cpu.endian");
        if((endian == null) || (endian.length() == 0))
        {
            Messenger.writeMsg(Messenger.EVT_PARAMETERS + Messenger.SEV_WARNING + Messenger.ALWAYS_PRINT,
                               "System getProperty failed to find sun.cpu.endian Java property.  Assuming big endian.\n");
            return;
        }

        //Check for "little" (LINUX_SETTING).  If so, turn on the reversal flag.
        Messenger.writeMsg(Messenger.EVT_PARAMETERS + Messenger.SEV_INFO + Messenger.ALWAYS_PRINT,
                           "The system property sun.cpu.edian was found to be \"" + endian + "\".\n");
        if(endian.equalsIgnoreCase("little"))
        {
            Messenger.writeMsg(Messenger.EVT_PARAMETERS + Messenger.SEV_INFO + Messenger.ALWAYS_PRINT,
                               "Bytes will be reversed for little-endian.\n");
            _reversebytesflag = true;
        }
        else
        {
            Messenger.writeMsg(Messenger.EVT_PARAMETERS + Messenger.SEV_INFO + Messenger.ALWAYS_PRINT,
                               "Bytes will NOT be reversed... assuming big-endian.\n");
        }
    }

    /**
     * This is the default constructor and will just call super and set the _reversebytesflag to the passed in flag.
     * Note that the flag should be one of the static flag variables above, for sanity sake.
     * 
     * @param in
     * @param flag
     */
    public HBinaryOutputStream(final OutputStream out, final boolean flag)
    {
        //Call the constructor for the super class.
        super(out);

        //Set the flag to determine if endians are to be swapped.
        _reversebytesflag = flag;
    }

    /**
     * Reverse the bytes in the passed in array; do the swap!
     * 
     * @param bytearray Array of bytes.
     * @return Reversed array of bytes.
     */
    public byte[] reverseBytes(final byte[] bytearray)
    {
        int i = 0;
        int j = bytearray.length - 1;
        byte tmpbyte;

        //Loop through until i is no longer less than j.
        for(i = 0; i < j; i++)
        {
            //swap the bytes in the i and j position.
            tmpbyte = bytearray[i];
            bytearray[i] = bytearray[j];
            bytearray[j] = tmpbyte;

            //decrement j.
            j--;
        }

        return bytearray;
    }

    /**
     * Reads in a float; uses readByteArraySwap to read bytes for swapping.
     */
    public void writeFloatSwap(final float value) throws IOException
    {
        //Create a byteStream that is of the appropriate size.  Map a DataOutputStream to it
        //and write the float to that.
        final ByteArrayOutputStream byteStream = new ByteArrayOutputStream(FLOAT_SIZE);
        final DataOutputStream binFile = new DataOutputStream(byteStream);
        binFile.writeFloat(value);

        //Get the resulting byte array and reverse it if needed.
        byte[] byteArray = byteStream.toByteArray();
        if(_reversebytesflag)
        {
            //Add some stuff here to swap the endians.
            byteArray = reverseBytes(byteArray);
        }

        //Write out the byte array.
        this.write(byteArray);
    }

    /**
     * Reads in a float; uses readByteArraySwap to read bytes for swapping.
     */
    public void writeDoubleSwap(final double value) throws IOException
    {
        //Create a byteStream that is of the appropriate size.  Map a DataOutputStream to it
        //and write the float to that.
        final ByteArrayOutputStream byteStream = new ByteArrayOutputStream(DOUBLE_SIZE);
        final DataOutputStream binFile = new DataOutputStream(byteStream);
        binFile.writeDouble(value);

        //Get the resulting byte array and reverse it if needed.
        byte[] byteArray = byteStream.toByteArray();
        if(_reversebytesflag)
        {
            //Add some stuff here to swap the endians.
            byteArray = reverseBytes(byteArray);
        }

        //Write out the byte array.
        this.write(byteArray);
    }

    /**
     * Reads in a float; uses readByteArraySwap to read bytes for swapping.
     */
    public void writeIntSwap(final int value) throws IOException
    {
        //Create a byteStream that is of the appropriate size.  Map a DataOutputStream to it
        //and write the float to that.
        final ByteArrayOutputStream byteStream = new ByteArrayOutputStream(INT_SIZE);
        final DataOutputStream binFile = new DataOutputStream(byteStream);
        binFile.writeInt(value);

        //Get the resulting byte array and reverse it if needed.
        byte[] byteArray = byteStream.toByteArray();
        if(_reversebytesflag)
        {
            //Add some stuff here to swap the endians.
            byteArray = reverseBytes(byteArray);
        }

        //Write out the byte array.
        this.write(byteArray);
    }

    /**
     * Reads in a float; uses readByteArraySwap to read bytes for swapping.
     */
    public void writeLongSwap(final long value) throws IOException
    {
        //Create a byteStream that is of the appropriate size.  Map a DataOutputStream to it
        //and write the float to that.
        final ByteArrayOutputStream byteStream = new ByteArrayOutputStream(LONG_SIZE);
        final DataOutputStream binFile = new DataOutputStream(byteStream);
        binFile.writeLong(value);

        //Get the resulting byte array and reverse it if needed.
        byte[] byteArray = byteStream.toByteArray();
        if(_reversebytesflag)
        {
            //Add some stuff here to swap the endians.
            byteArray = reverseBytes(byteArray);
        }

        //Write out the byte array.
        this.write(byteArray);
    }

    /**
     * Reads in a float; uses readByteArraySwap to read bytes for swapping.
     */
    public void writeShortSwap(final short value) throws IOException
    {
        //Create a byteStream that is of the appropriate size.  Map a DataOutputStream to it
        //and write the float to that.
        final ByteArrayOutputStream byteStream = new ByteArrayOutputStream(SHORT_SIZE);
        final DataOutputStream binFile = new DataOutputStream(byteStream);
        binFile.writeShort(value);

        //Get the resulting byte array and reverse it if needed.
        byte[] byteArray = byteStream.toByteArray();
        if(_reversebytesflag)
        {
            //Add some stuff here to swap the endians.
            byteArray = reverseBytes(byteArray);
        }

        //Write out the byte array.
        this.write(byteArray);
    }

    /**
     * Endian flag should be true if the file to read in requires swapping (i.e. is in little endian) or false
     * otherwise. Static vars LITTLE_ENDIAN_DATA_FLAG and BIG_ENDIAN_DATA_FLAG can be used. Wrapper on
     * setReverseBytesFlag.
     * 
     * @param flag The new flag value.
     */
    public void setEndianFlag(final boolean flag)
    {
        setReverseBytesFlag(flag);
    }

    /**
     * Sets the reverse bytes flag.
     * 
     * @param flag The new flag value.
     */
    public void setReverseBytesFlag(final boolean flag)
    {
        _reversebytesflag = flag;
    }

    public boolean getEndianFlag()
    {
        return getReverseBytesFlag();
    }

    public boolean getReverseBytesFlag()
    {
        return _reversebytesflag;
    }

}
