package ohd.hseb.util.misc;

/**
 * This is a class that provides some additional number methods. Note that the String word that is an argument in some
 * methods is first parsed into an integer before being used, so that false is automatically returned if the String is
 * not an integer.
 * 
 * @author hank
 */
public class HNumber
{

    ////////////////////////////////////////////////////
    //Static methods.
    ////////////////////////////////////////////////////

    /**
     * Return true iff word is an integer between lb and ub, INCLUSIVE. False is returned otherwise.
     */
    public static boolean isIntegerWithin(String word, int lb, int ub)
    {
        //Try to convert the string to an int.
        int value;
        try
        {
            value = Integer.parseInt(word);
        }
        catch(NumberFormatException e1)
        {
            return false;
        }

        //Check the bounds.
        if((lb > value) || (ub < value))
        {
            return false;
        }

        return true;
    }

    /**
     * Returns true if the word is an integer either less than or greater than bound (INCLUSIVE) where if upperbound is
     * true, then word must be less than bound, or if false greater than bound.
     * 
     * @param word
     * @param bound
     * @param upperbound
     * @return
     */
    public static boolean isIntegerBoundedBy(String word, int bound, boolean upperbound)
    {
        //Try to convert the string to an int.
        int value;
        try
        {
            value = Integer.parseInt(word);
        }
        catch(NumberFormatException e1)
        {
            return false;
        }

        //Check the bounds.  If the bound is an upperbound and value is larger than it, then I fail.
        if((upperbound) && (value > bound))
        {
            return false;
        }
        //If bound is a lowerbound and value is smaller than it, then I fail.
        if((!upperbound) && (value < bound))
        {
            return false;
        }

        return true;
    }

    /**
     * @param number The number to round.
     * @param decimalPlaces The number of decimal places.
     * @return The rounded double.
     */
    public static double roundDouble(double number, int decimalPlaces)
    {
    	if (Double.isNaN(number))
    	{
    		return number;
    	}
    	else
    	{
    		return (Math.round(number * Math.pow(10, decimalPlaces))) / Math.pow(10, decimalPlaces);
    	}
    }

    /**
     * @param number The number to divide.
     * @param divisor The divisor.
     * @return Return true if the latter evenly divides the former. The level of tolerance is 0.000001, so if
     *         number/divisor - (int)(number/divisor) > 0.000001, then false is returned.
     */
    public static boolean isNumberDivisibleByDivisor(double number, double divisor)
    {
        double test = number / divisor;
        if(test - (int)test > 0.000001)
        {
            return false;
        }
        return true;
    }

    /**
     * @param number The number to check.
     * @return Return true if the number is a power of 10. The level of tolerance is 0.000001, so if log(number) -
     *         (int)(log(number)) > 0.000001, then false is returned.
     */
    public static boolean isNumberAPowerOf10(double number)
    {
        double test = Math.log10(number);
        if(test - (int)test > 0.000001)
        {
            return false;
        }
        return true;
    }

    /**
     * Return the number of decimal places needed for a number by using a string.
     * 
     * @param number The number of compute the decimal places of.
     * @param maxDecimalPlaces The maximum allowed return value.
     * @return The number of decimal places that will allow for showing the significant digits of the number, or the
     *         maximum allowed.
     */
    public static int computeDecimalPlaces(double number, int maxDecimalPlaces)
    {
//        int decimalPlaces = 0;

        //Round to make sure it doesn't print all the extra digits sometimes associated
        //with a double.
        String numberString = HString.removeTrailingCharacter("" + HNumber.roundDouble(number, maxDecimalPlaces), '0');

        int decimalIndex = numberString.indexOf('.');
        if(decimalIndex < 0)
        {
            return 0;
        }
        return Math.min(maxDecimalPlaces, numberString.length() - decimalIndex - 1);
    }

}
