/*
 * Created on Mar 5, 2007 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.util.misc;

import java.util.Calendar;

/**
 * A basic start/stop timer. Just construct it to start the stop watch and call stop() to stop it. The method
 * {@link #getElapsedMillis()} will return the accumulated time from all start-stops in milliseconds and will stop the
 * stop watch if it has not already been stopped. To restart the watch and reset the accumulated time to 0, call
 * {@link #reset()}.
 * 
 * @author hank To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code
 *         Generation&gt;Code and Comments
 */
public class HStopWatch
{
    private Calendar _start;
    private Calendar _stop;
    private long _accumulatedTime = 0L;

    public HStopWatch()
    {
        this(true);
    }

    public HStopWatch(boolean startNow)
    {
        if(startNow)
        {
            start();
        }
    }

    /**
     * Stops the stop watch and adds elapsed time to {@link #_accumulatedTime}.
     */
    public void stop()
    {
        if(_start == null)
        {
            return;
        }
        _stop = Calendar.getInstance();
        _accumulatedTime += _stop.getTimeInMillis() - _start.getTimeInMillis();
    }

    /**
     * This will stop the watch!
     * 
     * @return The total accumulated time from all start-stops.
     */
    public long getElapsedMillis()
    {
        if((_stop == null) && (_start != null))
        {
            stop();
        }
        return _accumulatedTime;
    }

    public long getElapsedMillisWithoutStopping()
    {
        return Calendar.getInstance().getTimeInMillis() - _start.getTimeInMillis();
    }

    /**
     * Resets the stop watch. This calls {@link #start()} and then sets {@link #_accumulatedTime} to 0.
     */
    public void reset()
    {
        start();
        _accumulatedTime = 0;
    }

    /**
     * Start the stop watch again. This resets the starting point
     */
    public void start()
    {
        _start = Calendar.getInstance();
        _stop = null;
    }

}
