/*
 * Created on Aug 24, 2007
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package ohd.hseb.util.misc;

import javax.swing.JMenu;


/**
 * Class takes a JMenu menu item.
 * @author hank
 */
public class MemoryUsageMeter extends Thread
{

    private JMenu _menuItem;
    private Runtime _runtime;
    
    
    /**
     * Constructor requires a JMenu component.  This will set the text of the menu and a tool tip.
     * Just pass it a blank JMenu with the Font set.  Then, add the JMenu to a menu bar to see the
     * memory usage.  Refresh rate is 2 seconds (it sleeps 2 seconds between updates).
     * @param comp
     */
    public MemoryUsageMeter(JMenu comp)
    {
        _menuItem = comp;
        _menuItem.setToolTipText(
            "<html>Specifies about of memory being used by the IVP relative to the total<br>" +
            "amount that can be used for this application (dictated by Java).  Memory<br>" +
            "usage will fluctuate whenever Java performs a \"garbage collect\" to clean up<br>" +
            "its memory.</html>");
        _runtime = Runtime.getRuntime();
    }


    /**
     * Updates the memory usage MI.
     */
    private void updateMemoryUsageMI()
    {
        _menuItem.setText("Mem: " + 
            (int)((100.0)*( (double)(_runtime.totalMemory() - _runtime.freeMemory()) / (double)_runtime.maxMemory())) + 
            "% used  ");
    }
    
    
    /**
     * The run method.
     */
    public void run() 
    {
        while (true)
        {
            updateMemoryUsageMI();
            try 
            {
                sleep(2000);
            } 
            catch (InterruptedException e) 
            {
                e.printStackTrace();
            }
        }
        
            
    }

}
