/**
 * 
 */
package ohd.hseb.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import nl.wldelft.util.IndentingXMLStreamWriter;

/**
 * @author kretzt
 */
public class OHDXmlUtils
{

    private OHDXmlUtils()
    {

    }

    public static void parse(final String filename, final ContentHandler handler) throws SAXException, ParserConfigurationException
    {
        FileInputStream fis = null;
        BufferedInputStream bis = null;

        try
        {
            fis = new FileInputStream(new File(filename));
            bis = new BufferedInputStream(fis);

            if(filename.toLowerCase().endsWith(".fi"))
            {
                // handle fast infosets files
                //final XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.xml.fastinfoset.sax.SAXDocumentParser");
            	SAXParser saxParser =  SAXParserFactory.newInstance().newSAXParser();
            	final XMLReader parser = saxParser.getXMLReader();
                parser.setContentHandler(handler);

                final InputSource source = new InputSource(bis);
                source.setPublicId(filename);

                parser.parse(source);

            }
            else
            {
                // handle XML files
                final SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                XMLReader parser;

                try
                {            	SAXParser saxParser =  SAXParserFactory.newInstance().newSAXParser();
            	parser = saxParser.getXMLReader();
                parser.setContentHandler(handler);
                    parser = factory.newSAXParser().getXMLReader();
                }
                catch(final ParserConfigurationException e)
                {
                    throw new RuntimeException(e);
                }

                parser.setContentHandler(handler);

                final InputSource source = new InputSource(bis);
                source.setPublicId(filename);

                parser.parse(source);

            }
        }
        catch(final IOException e)
        {
            e.printStackTrace();
        }
        finally
        {
            try
            {
                bis.close();
                fis.close();
            }
            catch(final IOException e)
            {
                e.printStackTrace();
            }
        }
    } // end of parse method

    public static void parse(final BufferedInputStream bis, final String filename, final ContentHandler handler) throws SAXException,
                                                                                                                IOException, ParserConfigurationException
    {
        if(filename.toLowerCase().endsWith(".fi"))
        {
            // handle fast infosets files
            //final XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.xml.fastinfoset.sax.SAXDocumentParser");
        	SAXParser saxParser =  SAXParserFactory.newInstance().newSAXParser();
        	final XMLReader parser = saxParser.getXMLReader();
        	parser.setContentHandler(handler);

            final InputSource source = new InputSource(bis);
            source.setPublicId(filename);

            parser.parse(source);

        }
        else
        {
            // handle XML files
            final SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader parser;

            try
            {
                parser = factory.newSAXParser().getXMLReader();
            }
            catch(final ParserConfigurationException e)
            {
                throw new RuntimeException(e);
            }

            parser.setContentHandler(handler);

            final InputSource source = new InputSource(bis);
            source.setPublicId(filename);

            parser.parse(source);

        }
    } // end of parse method using buffered input stream

    public static void parse(final InputSource source, final ContentHandler handler, final String property) throws SAXException,
                                                                                                           IOException
    {

        // handle XML files
        final SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLReader parser;

        try
        {
            parser = factory.newSAXParser().getXMLReader();
        }
        catch(final ParserConfigurationException e)
        {
            throw new RuntimeException(e);
        }
        if(property != null) //|| property.isEmpty() == false)
        {
            parser.setProperty(property, handler);
        }
        parser.setContentHandler(handler);

        parser.parse(source);

    } // end of parse method using buffered input stource

    public static void parse(final InputSource source, final ContentHandler handler) throws SAXException, IOException
    {
        OHDXmlUtils.parse(source, handler, "");
    } // end of parse method using input source without properties

    public static XMLStreamReader getStreamReader(final BufferedInputStream bis, final String filename) throws SAXException,
                                                                                                       XMLStreamException
    {
        XMLInputFactory factory;
        XMLStreamReader reader = null;

        if(filename.toLowerCase().endsWith(".fi"))
        {
            // factory = StAXInputFactory.newInstance();
            reader = new StAXDocumentParser(bis);
        }
        else
        {
            final StreamSource source = new StreamSource(bis);
            source.setSystemId(filename);
            factory = XMLInputFactory.newInstance();
            reader = factory.createXMLStreamReader(source);
        }

        return reader;

    } // end of getStreamReader method

    public static XMLStreamWriter getStreamWriter(final BufferedOutputStream bos, final String filename) throws SAXException,
                                                                                                        XMLStreamException
    {
        XMLOutputFactory factory;
        XMLStreamWriter writer;

        if(filename.toLowerCase().endsWith(".fi"))
        {
            // factory = StAXOutputFactory.newInstance();
            final StAXDocumentSerializer staxDocumentSerializer = new StAXDocumentSerializer();
            staxDocumentSerializer.setOutputStream(bos);

            // Obtain XMLStreamWriter interface
            writer = staxDocumentSerializer;

        }
        else
        {
            // StreamResult result = new StreamResult(bos);
            // result.setSystemId(filename);
            factory = XMLOutputFactory.newInstance();

            // writer = new
            // IndentingXMLStreamWriter(factory.createXMLStreamWriter(result));
            writer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(bos, "utf-8"));
        }

        return writer;

    } // end of getStreamWriter method

}
