package ohd.hseb.hefs.mefp.adapter;

import java.io.File;
import java.io.IOException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.hefs.mefp.models.parameters.MEFPFullModelParameters;
import ohd.hseb.hefs.mefp.models.parameters.MEFPSourceModelParameters;

/* import ohd.hseb.hefs.mefp.sources.gefs.GEFSDataHandler;
   import ohd.hseb.hefs.mefp.sources.gefs.GEFSForecastSource; */

import ohd.hseb.hefs.pe.sources.SourceDataHandler;
import ohd.hseb.hefs.mefp.sources.plugin.PluginForecastSource;
import ohd.hseb.hefs.mefp.sources.plugin.PluginDataHandler;
import ohd.hseb.hefs.pe.sources.ForecastSourceTools;

import ohd.hseb.hefs.mefp.tools.MEFPTools;
import ohd.hseb.hefs.mefp.tools.canonical.SourceCanonicalEventValues;
import ohd.hseb.hefs.utils.tools.ParameterId;

/**
 * Code that will update an MEFP parameter so that it includes events updated to the latest GEFSv12 reforecast
 * files without actually modifying parameter values.
 *
 * Arg 0 = mefppeRunArea directory
 * Arg 1 = existing parameter file
 * 
 * @author James Ward after Hank.Herr's NewGEFSParameterFileUpdater
 */
public class NewGEFSv12ParameterFileUpdater
{
    private static final Logger LOG = LogManager.getLogger(NewGEFSv12ParameterFileUpdater.class);

    public static void main(final String[] args) throws IOException
    {
        //The GEFSv12 forecast source.
        //final PluginForecastSource gefsv12Source = new PluginForecastSource("GEFSv12");
        final PluginForecastSource gefsv12Source = new PluginForecastSource();

        gefsv12Source.setForecastSourceId("GEFSv12");

        //Loads the parameters.
        final MEFPFullModelParameters existingParameters = MEFPTools.instantiateMEFPFullModelParametersForReading();
        try
        {
            existingParameters.readParametersTarArchive(new File(args[1]));
        }
        catch(final Exception e)
        {
            e.printStackTrace();
            LOG.error("Unexpected exception reading parameter file: " + e.getMessage());
            return;
        }

        //Prepare the data handler and load prepared time series for all data types based on the identifier.
        PluginDataHandler dataHandler = null;
        try
        {
            dataHandler = new PluginDataHandler(new File(args[0]), "GEFSv12");
            dataHandler.loadPreparedTimeSeries(Lists.newArrayList(existingParameters.getIdentifier()));
            if(dataHandler.getAllLoadedForecastTimeSeries().isEmpty())
            {
                LOG.error("No reforecast time series were read in so events cannot be computed.  Aborting.");
                return;
            }
        }
        catch(final Exception e)
        {
            e.printStackTrace();
            LOG.error("Unexpected exception preparing data handler and loading data: " + e.getMessage());
            return;
        }

        //Ger the source event values for storing the new events.
        
     // Added try/catch per Freddy Camacho
     
     try
     {
LOG.info("before existingParameters.getSourceModelParameters(gefsv12Source)");
//System.out.println("before existingParameters.getSourceModelParameters(gefsv12Source)");
        final MEFPSourceModelParameters srcModelParms = existingParameters.getSourceModelParameters(gefsv12Source);
LOG.info("after existingParameters.getSourceModelParameters(gefsv12Source)");
//System.out.println("after  existingParameters.getSourceModelParameters(gefsv12Source)");

        //=======================================
        //Precipitation processing...
        //=======================================
        
        if(existingParameters.getIdentifier().isPrecipitationDataType())
        {
            LOG.info("Recomputing event values for precipitation....");
            //Get the values instance that will be updated.
LOG.info("before getPrecipitationSourceEventValues");
// System.out.println("before getPrecipitationSourceEventValues");
            final SourceCanonicalEventValues values = srcModelParms.getPrecipitationSourceEventValues();
LOG.info("after getPrecipitationSourceEventValues");
// System.out.println("after  getPrecipitationSourceEventValues");

            //Compute the events and store in values.
            //
            values.clear();
            values.computeCanonicalEventValues(existingParameters.getIdentifier(),
                                               ParameterId.FMAP,
                                               existingParameters.getSingleHistoricalTimeSeries(),
                                               dataHandler);
            if(values.getNumberOfForecastTimesWithValues() == 0)
            {
                System.err.println("No canonical events were found; perhaps the file wasn't found.  Aborting...");
                return;
            }
            LOG.info("Computing done!");
        }

        //=======================================
        //Temperature processing...
        //=======================================
        
        else
        {
            //The historical ts will include one for min and one for max.  Loop for each one.
            for(final TimeSeriesArray histTS: existingParameters.getHistoricalTimeSeries())
            {
                //Get the values instance that will be updated.
                LOG.info("Recomputing event values for " + histTS.getHeader().getParameterId() + "...");

                //Parameter Id must be the forecast version of the historical parameter.
                //Also identify the canonical event values object to be cleared and populated.
                ParameterId usedId = ParameterId.TFMX;
LOG.info("before getTMAXSourceEventValues");
// System.out.println("before getTMAXSourceEventValues");
                SourceCanonicalEventValues values = srcModelParms.getTMAXSourceEventValues();
LOG.info("after getTMAXSourceEventValues");
// System.out.println("after  getTMAXSourceEventValues");
                if(ParameterId.of(histTS.getHeader()).isMin())
                {
                    usedId = ParameterId.TFMN;
                    values = srcModelParms.getTMINSourceEventValues();
                }

                //Compute the events and store in values.
                values.clear();
                values.computeCanonicalEventValues(existingParameters.getIdentifier(), usedId, histTS, dataHandler);
                if(values.getNumberOfForecastTimesWithValues() == 0)
                {
                    System.err.println("No canonical events were found; perhaps the file wasn't found.  Aborting...");
                    return;
                }
                LOG.info("Computing done!");
            }
        }
     }
     catch(final Exception e)
     {
         e.printStackTrace();
         LOG.error("Unexpected exception preparing data handler and loading data: " + e.getMessage());
         return;
     }

        //Removing any existing file and writing out the file.
        
        try
        {
            final File inFile = new File(args[1]);

            //Determine the base directory for output.
            String baseDir = ".";
            if(!Strings.isNullOrEmpty(inFile.getParent())) //Could occur if directory not included in file name to process.
            {
                baseDir = inFile.getParent();
            }
            final File outFile = new File(baseDir + "/updated." + inFile.getName());

            //Delete and write.
            LOG.info("Removing file " + outFile.getAbsolutePath()
                + " if it exists and writing updated parameter file...");
            outFile.delete();
            existingParameters.writeParametersTarArchive(outFile, true);
            LOG.info("Writing done!");
        }
        catch(final Exception e)
        {
            e.printStackTrace();
            LOG.error("Unexpected exception writing updated MEFP parameter file: " + e.getMessage());
            return;
        }
    }
}
