package ohd.hseb.hefs.mefp.models;

import ohd.hseb.hefs.mefp.tools.canonical.CanonicalEvent;

/**
 * Interface that must be implemented by any forecast ensemble calculator to be called within
 * {@link MEFPEnsembleGeneratorModel}.
 * 
 * @author hankherr
 */
public interface ForecastEnsembleCalculator
{
    /**
     * Calculates a forecast ensemble and returns it as an array of double.
     * 
     * @param event The event for which to calculate a forecast ensemble.
     * @param canonicalEventValue The value of the event.
     * @param numberOfEnsembleMembers The number of ensemble members to generate.
     * @return The ensemble members.
     * @throws Exception For many possible reasons.
     */
    public double[] calculateForecastEnsemble(final CanonicalEvent event,
                                              final double canonicalEventValue,
                                              final int numberOfEnsembleMembers) throws Exception;
}
