package ohd.hseb.hefs.mefp.models.parameters;

import ohd.hseb.hefs.pe.model.ModelParameterType;

public abstract class MEFPModelParameterType extends ModelParameterType
{
    protected MEFPModelParameterType(final String parameterId, final boolean isForecast)
    {
        setParameterId(parameterId);
        setOptionalParameterFromForecastFlag(isForecast);
    }

    protected void setOptionalParameterFromForecastFlag(final boolean isForecast)
    {
        if(isForecast)
        {
            setOptionalExtraIdentifier("Forecasts");
        }
        else
        {
            setOptionalExtraIdentifier("Observations");
        }
    }

    protected boolean isForecast()
    {
        return getOptionalExtraIdentifier().equals("Forecasts");
    }

}
