package ohd.hseb.hefs.mefp.models.parameters.types;

import ohd.hseb.hefs.pe.model.ModelParameterType;

public class EPTFcstZeroObsDistributionParameterType extends ModelParameterType
{

    public EPTFcstZeroObsDistributionParameterType(final String parameterId, final int index)
    {
        setParameterId(parameterId);
        setParameterIndex(index);
    }

    @Override
    public double computeValue(final double[] canonicalEventForecasts, final double[] canonicalEventObservations)
    {
        return 0;
    }

    @Override
    public String getName()
    {
        return "Dist Parm " + getParameterIndex() + ": Fcst Cond on Zero Obs (EPT)";
    }

    @Override
    public Class<Float> getValueTypeClass()
    {
        return Float.class;
    }

    @Override
    public String getUnit()
    {
        return null;
    }

}
