package ohd.hseb.hefs.mefp.models.parameters.types;

import ohd.hseb.hefs.pe.model.ModelParameterType;

public class EPTObsZeroFcstDistributionParameterType extends ModelParameterType
{

    public EPTObsZeroFcstDistributionParameterType(final String parameterId, final int index)
    {
        setParameterId(parameterId);
        setParameterIndex(index);
    }

    @Override
    public double computeValue(final double[] canonicalEventForecasts, final double[] canonicalEventObservations)
    {
        return 0;
    }

    @Override
    public String getName()
    {
        return "Dist Parm " + getParameterIndex() + ": Obs Cond on Zero Fcst (EPT)";
    }

    @Override
    public Class<Float> getValueTypeClass()
    {
        return Float.class;
    }

    @Override
    public String getUnit()
    {
        return null;
    }

}
