package ohd.hseb.hefs.mefp.models.parameters.types;

import ohd.hseb.hefs.mefp.models.parameters.MEFPModelParameterType;

public class POPParameterType extends MEFPModelParameterType
{
    public POPParameterType(final String parameterId, final boolean isForecast)
    {
        super(parameterId, isForecast);
    }

    @Override
    public double computeValue(final double[] canonicalEventForecasts, final double[] canonicalEventObservations)
    {
        return 0;
    }

    @Override
    public String getName()
    {
        return "Probability of Precipitation for " + getOptionalExtraIdentifier().toString();
    }

    @Override
    public Class<Float> getValueTypeClass()
    {
        return Float.class;
    }

    @Override
    public String getUnit()
    {
        return null;
    }

    @Override
    public double getMinimumDisplayValue()
    {
        return 0.0d;
    }

    @Override
    public double getMaximumDisplayValue()
    {
        return 1.0d;
    }
}
