package ohd.hseb.hefs.mefp.models.parameters.types;

import ohd.hseb.hefs.pe.model.ModelParameterType;

public class RhoParameterType extends ModelParameterType
{
    public RhoParameterType(final String parameterId)
    {
        setParameterId(parameterId);
    }

    @Override
    public double computeValue(final double[] canonicalEventForecasts, final double[] canonicalEventObservations)
    {
        return 0;
    }

    @Override
    public String getName()
    {
        return "Correlation (Rho) Between Forecasts and Observations";
    }

    @Override
    public Class<Float> getValueTypeClass()
    {
        return Float.class;
    }

    @Override
    public String getUnit()
    {
        return null;
    }

    @Override
    public double getMinimumDisplayValue()
    {
        return 0.0d;
    }

    @Override
    public double getMaximumDisplayValue()
    {
        return 1.0d;
    }
}
