package ohd.hseb.hefs.mefp.models.parameters.types;

import ohd.hseb.hefs.mefp.models.parameters.MEFPModelParameterType;

public class StdDevParameterType extends MEFPModelParameterType
{
    public StdDevParameterType(final String parameterId, final boolean isForecast)
    {
        super(parameterId, isForecast);
    }

    @Override
    public double computeValue(final double[] canonicalEventForecasts, final double[] canonicalEventObservations)
    {
        return 0;
    }

    @Override
    public String getName()
    {
        return "Standard Deviation of " + getOptionalExtraIdentifier().toString();
    }

    @Override
    public Class<Float> getValueTypeClass()
    {
        return Float.class;
    }

    @Override
    public double getMinimumDisplayValue()
    {
        return 0.0d;
    }
}
