package ohd.hseb.hefs.mefp.models.precipitation;

import java.util.List;

import ohd.hseb.hefs.mefp.models.MEFPBaseModelControlOptions;
import ohd.hseb.hefs.pe.estimation.options.ControlOption;
import ohd.hseb.hefs.pe.estimation.options.IntegerEstimationOption;

import com.google.common.collect.Lists;

/**
 * Control options base class for MEFP's precipitation data type. The commented out code are control options that are
 * not used in the Java recoded version of the algorithm.
 * 
 * @author hankherr
 */
public class MEFPPrecipitationModelControlOptions extends MEFPBaseModelControlOptions
{
//    private final ChoiceEstimationParameter _rhoOption = null;
//    private FloatEstimationParameter _corWeight = null;
    private IntegerEstimationOption _minposobs = null;
    private IntegerEstimationOption _minposfcst = null;
//    private DoubleEstimationParameter _pmaxvalue = null;
    private MEFPPrecipitationModelEPTControlOptions _ept = null;
    private MEFPPrecipitationModelIPTControlOptions _ipt = null;

    public MEFPPrecipitationModelControlOptions()
    {
        super("precipitationModelParameters", createParameters());
        mapAttributes();
    }

    public MEFPPrecipitationModelControlOptions(final List<? extends ControlOption> parametersToUse)
    {
        super("precipitationModelParameters", parametersToUse);
        mapAttributes();
    }

    @Override
    protected void mapAttributes()
    {
        super.mapAttributes();
//      _rhoOption = (ChoiceEstimationParameter)_parameters.get(MEFPBaseModelControlOptions.NUM_PARAMETERS + 0);
//        _corWeight = (FloatEstimationParameter)_parameters.get(MEFPBaseModelControlOptions.NUM_PARAMETERS + 1);
        _minposobs = (IntegerEstimationOption)_parameters.get(MEFPBaseModelControlOptions.NUM_PARAMETERS + 0);
        _minposfcst = (IntegerEstimationOption)_parameters.get(MEFPBaseModelControlOptions.NUM_PARAMETERS + 1);
//        _pmaxvalue = (DoubleEstimationParameter)_parameters.get(MEFPBaseModelControlOptions.NUM_PARAMETERS + 4);
        _ipt = (MEFPPrecipitationModelIPTControlOptions)_parameters.get(MEFPBaseModelControlOptions.NUM_PARAMETERS + 2);
        _ept = (MEFPPrecipitationModelEPTControlOptions)_parameters.get(MEFPBaseModelControlOptions.NUM_PARAMETERS + 3);
    }

    private static final List<? extends ControlOption> createParameters()
    {
//Old correlation option.  Currently, the weighted average version is used where the weights are equal.
//      new ChoiceEstimationParameter("correlationComputationOption",
//      "Correlation computation choice (rho_option):",
//      1,
//      "untransformed correlation",
//      "quadrant-based",
//      "weighted average of previous two",
//      "untransformed corr., pos. values",
//      "transformed corr., pos. values"),
//        new FloatEstimationParameter("correlationWeight",
//        "Correlation weight (cor_weight):",
//        1.0f,
//        0.1f),
        return Lists.newArrayList(new IntegerEstimationOption("minimumNumberOfRequiredPositiveObservations", //Fortran: minposobs
                                                              "Minimum Required Pos. Obs. for Param. Est.:",
                                                              50),
                                  new IntegerEstimationOption("minimumNumberOfRequiredPositiveForecasts", //Fortran: minposfcst
                                                              "Minimum Required Pos. Fcst for Param. Est.:",
                                                              50),
//                                  new DoubleEstimationParameter("maximumMeanPrecipitationEnsembleValue",
//                                                                "Specify the max. mean precip. ens. value (pmaxvalue):",
//                                                                254d),

                                  new MEFPPrecipitationModelIPTControlOptions(),
                                  new MEFPPrecipitationModelEPTControlOptions());
    }

//    public int getCorrelationComputationOption()
//    {
//        return _rhoOption.get();
//    }
//
//    public void setCorrelationComputationOption(final int correlationComputationOption)
//    {
//        _rhoOption.set(correlationComputationOption);
//    }
//
//    public float getCorrelationWeight()
//    {
//        return _corWeight.get();
//    }
//
//    public void setCorrelationWeight(final float correlationWeight)
//    {
//        _corWeight.set(correlationWeight);
//    }

    public int getMinimumNumberOfRequiredPositiveObservations()
    {
        return _minposobs.get();
    }

    public void setMinimumNumberOfRequiredPositiveObservations(final int minimumNumberOfRequiredPositiveObservations)
    {
        _minposobs.set(minimumNumberOfRequiredPositiveObservations);
    }

    public int getMinimumNumberOfRequiredPositiveForecasts()
    {
        return _minposfcst.get();
    }

    public void setMinimumNumberOfRequiredPositiveForecasts(final int minimumNumberOfRequiredPositiveForecasts)
    {
        _minposfcst.set(minimumNumberOfRequiredPositiveForecasts);
    }

//    public double getMaximumMeanPrecipitationEnsembleValue()
//    {
//        return _pmaxvalue.get();
//    }
//
//    public void setMaximumMeanPrecipitationEnsembleValue(final double maximumMeanPrecipitationEnsembleValue)
//    {
//        _pmaxvalue.set(maximumMeanPrecipitationEnsembleValue);
//    }

    public MEFPPrecipitationModelEPTControlOptions getEPT()
    {
        return _ept;
    }

    public MEFPPrecipitationModelIPTControlOptions getIPT()
    {
        return _ipt;
    }

    @Override
    public MEFPPrecipitationModelControlOptions clone() throws CloneNotSupportedException
    {
        final MEFPPrecipitationModelControlOptions copy = new MEFPPrecipitationModelControlOptions();
        copy.copyFrom(this);
        return copy;
    }
}
