package ohd.hseb.hefs.mefp.models.precipitation;

import java.util.List;

import com.google.common.collect.Lists;

import ohd.hseb.hefs.pe.estimation.options.ControlOption;
import ohd.hseb.hefs.pe.estimation.options.DistributionEstimationOption;
import ohd.hseb.hefs.pe.estimation.options.FloatEstimationOption;
import ohd.hseb.hefs.pe.estimation.options.GenericCompositeControlOption;
import ohd.hseb.hefs.utils.dist.DistributionType;

/**
 * EPT model specific control parameters. Commented out code are related to parameters that are not used in the Java
 * recoded version. They mostly relate to a optimization method of parameter estimation that slows down MEFPPE to a
 * crawl. The original Fortran optimization code can be found in the EPT parameter estimation calculator.
 * 
 * @author hankherr
 */
public class MEFPPrecipitationModelEPTControlOptions extends GenericCompositeControlOption
{
    // XXX -- Until I hear otherwise, I'm going to ignore data_option. I appears to
    // allow EPP3 to go to a file to load EPP2 run-time information. I don't want to
    // allow this.
    // c idtype_epp2 = integer selector for pdf for wet events
    // c iadj_epp2 = parameter optimization option selector
    // c = 0 for no optimizations
    // c iobjfun_epp2 =
    // c ierrstd_epp2 =
    // c prob_epp2 =
    // c weight1_epp2 =
    // c weight2_epp2 =
    // c weight3_epp2 =
    // c errfactor_epp2 =
    // c ithreshopt_epp2 = precipitation threshold selector
    // c = 0 to use fixed threshold
    // c = 1 to use variable threshold
    // c pthresh_epp2 = fixed precipitation threshold (mm)
    // epp2_option = 'off'
    // data_option = 'off'
    // nparams_epp2 = 30
    // ithreshopt_epp2 = 0
    // pthresh_epp2 = 0.25
    // idtype_epp2 = 10
    // iadj_epp2 = 0
    // iobjfun_epp2 = 2
    // ierrstd_epp2 = 0
    // prob_epp2 = 0.6
    // weight1_epp2 = 0.
    // weight2_epp2 = 0.
    // weight3_epp2 = 1.
    // errfactor_epp2 = 1.

    private DistributionEstimationOption _idtype = null;
//    private IntegerNoEditEstimationParameter _iadj = null; -- the optimization option
//    private ChoiceEstimationParameter _iobjfun = null;
//    private FloatEstimationParameter _prob = null;
//    private FloatEstimationParameter _errfactor = null;
//    private ChoiceEstimationParameter _ithreshopt = null;
    private FloatEstimationOption _pthresh = null;

//    private FloatEstimationParameter _weight1 = null;
//    private FloatEstimationParameter _weight2 = null;
//    private FloatEstimationParameter _weight3 = null;
//    private ChoiceEstimationParameter _ierrstd = null;

    public MEFPPrecipitationModelEPTControlOptions()
    {
        super("precipitationEPTModelParameters", createParameters());
        setEditorBorderTitle("EPT Parameters");
        mapAttributes();
    }

    private void mapAttributes()
    {
        _idtype = (DistributionEstimationOption)_parameters.get(0);
//        _iadj = (IntegerNoEditEstimationParameter)_parameters.get(2);
//        _iobjfun = (ChoiceEstimationParameter)_parameters.get(3);
//        _prob = (FloatEstimationParameter)_parameters.get(4);
//        _errfactor = (FloatEstimationParameter)_parameters.get(5);
//        _ithreshopt = (ChoiceEstimationParameter)_parameters.get(6);
        _pthresh = (FloatEstimationOption)_parameters.get(1);
//        _weight1 = (FloatEstimationParameter)_parameters.get(8);
//        _weight2 = (FloatEstimationParameter)_parameters.get(9);
//        _weight3 = (FloatEstimationParameter)_parameters.get(10);
//        _ierrstd = (ChoiceEstimationParameter)_parameters.get(11);
    }

    private static final List<ControlOption> createParameters()
    {
        //&nbsp Is a symbol for a space that will not be ignored by Java used for indenting.  
        //Spaces after a <br> are ignored, making identing difficult.
        return Lists.newArrayList((ControlOption)new DistributionEstimationOption("eptDistributionType",
                                                                                  MEFPPrecipitationModelTools.getSelectableDistributionTypesEnumSet(),
                                                                                  "<html>Distribution to Use for Obs and<br>&nbsp&nbsp&nbsp&nbsp Fcst When Both Are Positive:</html>"),
//                                  new IntegerNoEditEstimationParameter("eptOptimizationOption", 0), //UNEDITABLE!
//                                  new ChoiceEstimationParameter("epp2OptimizationOption", //The EDITABLE version!
//                                                                "iadj_epp2",
//                                                                "EPP2 Optimization Option (iadj_epp2):",
//                                                                0,
//                                                                "no",
//                                                                "yes"),
//                                  new ChoiceEstimationParameter("eptObjectiveFunctionOption",
//                                                                "EPT Objective Function Option (iobjfun_epp2):",
//                                                                2,
//                                                                "Percentile",
//                                                                "Ensemble Mean",
//                                                                "Mean CRPS"),
//                                  new FloatEstimationParameter("eptProbability",
//                                                               "Specify the Probability to Use For Percentile Option (prob_epp2):",
//                                                               0.6f,
//                                                               0.01f,
//                                                               0.01f,
//                                                               0.99f),
//                                  new FloatEstimationParameter("eptErrFactor",
//                                                               "Specify the Resid Error Factor (errfactor_epp2):",
//                                                               1f,
//                                                               0.1f),
//                                  new ChoiceEstimationParameter("eptThresholdOption",
//                                                                "EPT Threshold Type Selection (ithreshopt_epp2):",
//                                                                0,
//                                                                "Fixed",
//                                                                "Variable"),
                                  new FloatEstimationOption("eptPrecipThreshold",
                                                            "Fixed Rain/No-Rain Defining Threshold (MM):",
                                                            0.25f,
                                                            0.1f)
//                                  new FloatEstimationParameter("eptOptimizationWeight1",
//                                                               "Specify Optimization Weight-1 (weight1_epp2):",
//                                                               0f,
//                                                               0.1f),
//                                  new FloatEstimationParameter("eptOptimizationWeight2",
//                                                               "Specify Optimization Weight-2 (weight2_epp2):",
//                                                               0f,
//                                                               0.1f),
//                                  new FloatEstimationParameter("eptOptimizationWeight3",
//                                                               "Specify Optimization Weight-3 (weight3_epp2):",
//                                                               1f,
//                                                               0.1f),
//                                  new ChoiceEstimationParameter("eptResidualErrorUse",
//                                                                "EPT Residual Error Use Option (ierrstd_epp2):",
//                                                                0,
//                                                                "Sample StdDev",
//                                                                "Median")
        );
    }

    public DistributionType getEPTDistribution()
    {
        return _idtype.get();
    }

    public void setEPTDistribution(final DistributionType distribution)
    {
        _idtype.set(distribution);
    }

//    public int getEPTOptimizationOption()
//    {
//        return _iadj.get();
//    }
//
//    public void setEPTOptimizationOption(final int eptOptimizationOption)
//    {
//        _iadj.set(eptOptimizationOption);
//    }

//    public int getEPTObjectiveFunctionOption()
//    {
//        return _iobjfun.get();
//    }
//
//    public void setEPTObjectiveFunctionOption(final int eptObjectiveFunctionOption)
//    {
//        _iobjfun.set(eptObjectiveFunctionOption);
//    }
//
//    public float getEPTProbability()
//    {
//        return _prob.get();
//    }
//
//    public void setEPTProbability(final float eptProbability)
//    {
//        _prob.set(eptProbability);
//    }
//
//    public float getEPTErrFactor()
//    {
//        return _errfactor.get();
//    }
//
//    public void setEPTErrFactor(final float eptErrFactor)
//    {
//        _errfactor.set(eptErrFactor);
//    }
//
//    public int getEPTThresholdOption()
//    {
//        return _ithreshopt.get();
//    }
//
//    public void setEPTThresholdOption(final int eptThresholdOption)
//    {
//        _ithreshopt.set(eptThresholdOption);
//    }

    public float getEPTPrecipThreshold()
    {
        return _pthresh.get();
    }

    public void setEPTPrecipThreshold(final float eptPrecipThreshold)
    {
        _pthresh.set(eptPrecipThreshold);
    }

//    public float getEPTOptimizationWeight1()
//    {
//        return _weight1.get();
//    }
//
//    public void setEPTOptimizationWeight1(final float eptOptimizationWeight1)
//    {
//        _weight1.set(eptOptimizationWeight1);
//    }
//
//    public float getEPTOptimizationWeight2()
//    {
//        return _weight2.get();
//    }
//
//    public void setEPTOptimizationWeight2(final float eptOptimizationWeight2)
//    {
//        _weight2.set(eptOptimizationWeight2);
//    }
//
//    public float getEPTOptimizationWeight3()
//    {
//        return _weight3.get();
//    }
//
//    public void setEPTOptimizationWeight3(final float eptOptimizationWeight3)
//    {
//        _weight3.set(eptOptimizationWeight3);
//    }
//
//    public int getEPTResidualErrorUse()
//    {
//        return _ierrstd.get();
//    }
//
//    public void setEPTResidualErrorUse(final int eptResidualErrorUse)
//    {
//        _ierrstd.set(eptResidualErrorUse);
//    }
    
    @Override
    public MEFPPrecipitationModelEPTControlOptions clone() throws CloneNotSupportedException
    {
        final MEFPPrecipitationModelEPTControlOptions copy = new MEFPPrecipitationModelEPTControlOptions();
        copy.copyFrom(this);
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        super.copyFrom(base);
        mapAttributes();
    }
}
