package ohd.hseb.hefs.mefp.models.precipitation;

import java.util.List;

import ohd.hseb.hefs.pe.estimation.options.ControlOption;
import ohd.hseb.hefs.pe.estimation.options.DoubleEstimationOption;
import ohd.hseb.hefs.pe.estimation.options.FloatEstimationOption;
import ohd.hseb.hefs.pe.estimation.options.GenericCompositeControlOption;

import com.google.common.collect.Lists;

/**
 * IPT model specific control parameters: the pop fraction defining rain/no-rain threshold, and the maximum on the
 * conditional mean precip value.
 * 
 * @author hankherr
 */
public class MEFPPrecipitationModelIPTControlOptions extends GenericCompositeControlOption
{

    private FloatEstimationOption _popFraction = null;
    private DoubleEstimationOption _cavnmax = null;

    public MEFPPrecipitationModelIPTControlOptions()
    {
        super("precipitationIPTModelParameters", createParameters());
        setEditorBorderTitle("IPT Parameters");
        mapAttributes();
    }

    private void mapAttributes()
    {
        _popFraction = (FloatEstimationOption)_parameters.get(0);
        _cavnmax = (DoubleEstimationOption)_parameters.get(1);
    }

    private static final List<ControlOption> createParameters()
    {
        return Lists.newArrayList((ControlOption)new FloatEstimationOption("fractionDefiningWetEvents",
                                                                           "Specify the Quantile Defining Wet Events:", //Fortran: pop_fraction
                                                                           0.97f,
                                                                           0.01f),

        new DoubleEstimationOption("maximumConditionalMeanPrecipitationValue",
                                   "Specify the max. cond. mean precip. ens. value (MM):", //Fortran: cavgmax
                                   50.8d));
    }

    public float getFractionDefiningWetEvents()
    {
        return _popFraction.get();
    }

    public void setFractionDefiningWetEvents(final float fractionDefiningWetEvents)
    {
        _popFraction.set(fractionDefiningWetEvents);
    }

    public double getMaximumConditionalMeanPrecipitationValue()
    {
        return _cavnmax.get();
    }

    public void setMaximumConditionalMeanPrecipitationValue(final double maximumConditionalMeaPrecipitationValue)
    {
        _cavnmax.set(maximumConditionalMeaPrecipitationValue);
    }

    @Override
    public MEFPPrecipitationModelIPTControlOptions clone() throws CloneNotSupportedException
    {
        final MEFPPrecipitationModelIPTControlOptions copy = new MEFPPrecipitationModelIPTControlOptions();
        copy.copyFrom(this);
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        super.copyFrom(base);
        mapAttributes();
    }
}
