package ohd.hseb.hefs.mefp.models.temperature;

import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.pe.model.ModelParameterType;
import ohd.hseb.hefs.pe.model.OneSetParameterValues;
import ohd.hseb.hefs.pe.model.ParameterEstimationModel;

/**
 * This class MUST be kept in sync with the list of parameters in the {@link TemperatureParameterEstimationModel}. I
 * have added sets and gets to allow for directly gathering parameters instead of having to know which
 * {@link ModelParameterType} to pass in. The sets/gets are based on the order of the parameters!
 * 
 * @author hank.herr
 */
public class TemperatureOneSetParameterValues extends OneSetParameterValues
{

    public TemperatureOneSetParameterValues(final int dayOfYear,
                                            final int secondaryIndex,
                                            final ParameterEstimationModel model,
                                            final MEFPForecastSource source)
    {
        super(dayOfYear, secondaryIndex, model, source);
    }

    public void copyParameters(final TemperatureOneSetParameterValues base)
    {
        this.setTmaxFcstAvg(base.getTmaxFcstAvg());
        this.setTmaxFcstStdDev(base.getTmaxFcstStdDev());
        this.setTmaxNumObs(base.getTmaxNumObs());
        this.setTmaxObsAvg(base.getTmaxObsAvg());
        this.setTmaxObsStdDev(base.getTmaxObsStdDev());
        this.setTmaxRho(base.getTmaxRho());

        this.setTminFcstAvg(base.getTminFcstAvg());
        this.setTminFcstStdDev(base.getTminFcstStdDev());
        this.setTminNumObs(base.getTminNumObs());
        this.setTminObsAvg(base.getTminObsAvg());
        this.setTminObsStdDev(base.getTminObsStdDev());
        this.setTminRho(base.getTminRho());
    }

//0    parameters.add(new AvgParameterType(HEFSTools.DEFAULT_TMIN_PARAMETER_ID, false));
//1    parameters.add(new AvgParameterType(HEFSTools.DEFAULT_TMIN_PARAMETER_ID, true));
//2    parameters.add(new StdDevParameterType(HEFSTools.DEFAULT_TMIN_PARAMETER_ID, false));
//3    parameters.add(new StdDevParameterType(HEFSTools.DEFAULT_TMIN_PARAMETER_ID, true));
//4    parameters.add(new RhoParameterType(HEFSTools.DEFAULT_TMIN_PARAMETER_ID));
//5    parameters.add(new NObsParameterType(HEFSTools.DEFAULT_TMIN_PARAMETER_ID));
//6    parameters.add(new AvgParameterType(HEFSTools.DEFAULT_TMAX_PARAMETER_ID, false));
//7    parameters.add(new AvgParameterType(HEFSTools.DEFAULT_TMAX_PARAMETER_ID, true));
//8    parameters.add(new StdDevParameterType(HEFSTools.DEFAULT_TMAX_PARAMETER_ID, false));
//9    parameters.add(new StdDevParameterType(HEFSTools.DEFAULT_TMAX_PARAMETER_ID, true));
//10   parameters.add(new RhoParameterType(HEFSTools.DEFAULT_TMAX_PARAMETER_ID));
//11   parameters.add(new NObsParameterType(HEFSTools.DEFAULT_TMAX_PARAMETER_ID));

    public double getTminObsAvg()
    {
        return getValue(0);
    }

    public void setTminObsAvg(final double value)
    {
        setValue(0, value);
    }

    public double getTminFcstAvg()
    {
        return getValue(1);
    }

    public void setTminFcstAvg(final double value)
    {
        setValue(1, value);
    }

    public double getTminObsStdDev()
    {
        return getValue(2);
    }

    public void setTminObsStdDev(final double value)
    {
        setValue(2, value);
    }

    public double getTminFcstStdDev()
    {
        return getValue(3);
    }

    public void setTminFcstStdDev(final double value)
    {
        setValue(3, value);
    }

    public double getTminRho()
    {
        return getValue(4);
    }

    public void setTminRho(final double value)
    {
        setValue(4, value);
    }

    public int getTminNumObs()
    {
        return (int)getValue(5);
    }

    public void setTminNumObs(final int value)
    {
        setValue(5, value);
    }

    public double getTmaxObsAvg()
    {
        return getValue(6);
    }

    public void setTmaxObsAvg(final double value)
    {
        setValue(6, value);
    }

    public double getTmaxFcstAvg()
    {
        return getValue(7);
    }

    public void setTmaxFcstAvg(final double value)
    {
        setValue(7, value);
    }

    public double getTmaxObsStdDev()
    {
        return getValue(8);
    }

    public void setTmaxObsStdDev(final double value)
    {
        setValue(8, value);
    }

    public double getTmaxFcstStdDev()
    {
        return getValue(9);
    }

    public void setTmaxFcstStdDev(final double value)
    {
        setValue(9, value);
    }

    public double getTmaxRho()
    {
        return getValue(10);
    }

    public void setTmaxRho(final double value)
    {
        setValue(10, value);
    }

    public int getTmaxNumObs()
    {
        return (int)getValue(11);
    }

    public void setTmaxNumObs(final int value)
    {
        setValue(11, value);
    }

}
