package ohd.hseb.hefs.mefp.pe;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;

import javax.swing.JFrame;

import nl.wldelft.util.LogUtils;
import ohd.hseb.hefs.mefp.pe.acceptance.MEFPAcceptancePEStepProcessor;
import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.pe.core.MEFPPerformAllStepsJob;
import ohd.hseb.hefs.mefp.pe.estimation.MEFPEstimationPEStepProcessor;
import ohd.hseb.hefs.mefp.pe.setup.MEFPPESetupPanel;
import ohd.hseb.hefs.mefp.sources.historical.HistoricalPEStepProcessor;
import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.gui.GenericParameterEstimatorExplorerPlugIn;
import ohd.hseb.hefs.pe.gui.PESetupPanel;
import ohd.hseb.hefs.utils.gui.about.AboutFile;
import ohd.hseb.hefs.utils.gui.help.HelpFile;
import ohd.hseb.hefs.utils.gui.tools.GlobalDialogParent;

@AboutFile("version/hefsplugins_config.xml")
@HelpFile("PDFHELP:helpManual.pdf#MEFPPEMainPanelRef")
@GlobalDialogParent
@SuppressWarnings("serial")
public class MEFPPEExplorerPlugIn extends GenericParameterEstimatorExplorerPlugIn
{
    public MEFPPEExplorerPlugIn()
    {
        super(new File(GenericParameterEstimatorExplorerPlugIn.getDefaultBaseDirectory(), "mefppeRunArea"),
              GenericParameterEstimatorExplorerPlugIn.getDefaultConfigDirectory());
    }

    public MEFPPEExplorerPlugIn(final File baseDirectory, final File configDirectory)
    {
        super(baseDirectory, configDirectory);
    }

    @Override
    protected ParameterEstimatorRunInfo createDefaultRunInfo(final ExecutorService executor,
                                                             final File baseDirectory,
                                                             final File configDirectory) throws Exception
    {
        final MEFPParameterEstimatorRunInfo runInfo = new MEFPParameterEstimatorRunInfo(executor,
                                                                                        baseDirectory,
                                                                                        configDirectory);
        runInfo.importOldCanonicalEvents();
        return runInfo;
    }

    @Override
    protected List<ParameterEstimatorStepProcessor> initializeStepProcessors()
    {
        final List<ParameterEstimatorStepProcessor> steps = super.initializeStepProcessors();

        //Move the historical PE step options panel to be the first step (while leaving it as the last source.
        //Position as a source is connected to how the algorithms work, so it cannot be moved.)
        ParameterEstimatorStepProcessor historicalStepProc = null;
        for(final ParameterEstimatorStepProcessor stepProc: steps)
        {
            if(stepProc instanceof HistoricalPEStepProcessor)
            {
                historicalStepProc = stepProc;
            }
        }
        steps.remove(historicalStepProc);
        steps.add(0, historicalStepProc);

        steps.add(new MEFPEstimationPEStepProcessor(getRunInfo()));
        steps.add(new MEFPAcceptancePEStepProcessor(getRunInfo()));
        return steps;
    }

    @Override
    public MEFPParameterEstimatorRunInfo getRunInfo()
    {
        return (MEFPParameterEstimatorRunInfo)super.getRunInfo();
    }

    @Override
    protected void reactToSuccessfulInitialization()
    {
        getLocationPanel().setPerformAllJobToUse(MEFPPerformAllStepsJob.class);
    }

    @Override
    protected PESetupPanel initializeParameterEstimatorSetupPanel()
    {
        return new MEFPPESetupPanel(getRunInfo());
    }

    /**
     * Test main, runs off guiTestBed.
     * @throws IOException 
     */
    public static void main(final String[] args) throws IOException
    {
        //Initialize logging using the Deltares/FEWS provided tool.  It must be called twice,
        //the first time ignoring exceptions.  This seems to work.
        try 
        {
              LogUtils.initConsole();
        }
        catch (final Throwable t)
        {
            System.out.println("Ignoring the exception from calling LogUtils.initConsole(); "
                + "first attempt always fails, but second should succeed.");
        }
        LogUtils.initConsole();
        
        System.getProperties().put("SHOW_DAYS_BETWEEN_T0S", "on"); //XXX sensitivity analysis - uncomment to use.
        try
        {
            //Testing the panel
            final MEFPPEExplorerPlugIn stepsPanel = new MEFPPEExplorerPlugIn(new File("testdata/guiTestBed"),
                                                                             new File("testoutput/guiTestOutput/Config"));

            final JFrame tableFrame = new JFrame("Table Panel");
            stepsPanel.run(null, null);
            tableFrame.setSize(1000, 750);
            tableFrame.setContentPane(stepsPanel);
            tableFrame.setVisible(true);
            tableFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            tableFrame.addWindowListener(new WindowAdapter()
            {
                @Override
                public void windowClosing(final WindowEvent e)
                {
                    stepsPanel.dispose();
                }
            });
        }
        catch(final Exception e)
        {
            e.printStackTrace();
            System.out.println("####>> MAIN FAILED ---- " + e.getMessage());
        }
    };
}
