package ohd.hseb.hefs.mefp.pe.acceptance;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.swing.JPanel;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepOptionsPanel;
import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.pe.notice.SelectedIdentifiersChangedNotice;
import ohd.hseb.hefs.pe.notice.StepStatusRefreshAllNotice;
import ohd.hseb.hefs.pe.tools.GenericSummaryTablePanel;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.gui.help.HelpFile;
import ohd.hseb.hefs.utils.tools.ListTools;

import com.google.common.eventbus.Subscribe;

/**
 * Top level panel for the Acceptance tab.
 * 
 * @author Xuning.Tan
 */
@SuppressWarnings("serial")
@HelpFile("PDFHELP:helpManual.pdf#AcceptanceSubpanelRef")
public class MEFPAcceptancePEStepOptionsPanel extends ParameterEstimatorStepOptionsPanel implements
SelectedIdentifiersChangedNotice.Subscriber, StepStatusRefreshAllNotice.Subscriber
{
    private GenericSummaryTablePanel _identifiersPanel;

    public MEFPAcceptancePEStepOptionsPanel(final ParameterEstimatorRunInfo runInfo,
                                            final MEFPAcceptancePEStepProcessor stepProc)
    {
        super(runInfo, stepProc);
        initializeDisplay();
    }

    private void refreshTable()
    {
        _identifiersPanel.refreshTable();
    }

    @Override
    protected void initializeDisplay()
    {
        //Identifier panel.
        final JPanel identifiersWrapperPanel = new JPanel(new BorderLayout());
        _identifiersPanel = new GenericSummaryTablePanel(getRunInfo(),
                                                         "Summary of Parameters Acceptance",
                                                         new MEFPIdentifierAcceptanceTableModel(getRunInfo()),
                                                         true,
                                                         Collections.<Component>emptyList());
        identifiersWrapperPanel.add(_identifiersPanel, BorderLayout.CENTER);

        this.setLayout(new BorderLayout());
        this.add(_identifiersPanel);
    }

    @Override
    public List<? extends StepUnit> getStepUnitsToPerform()
    {
        return _identifiersPanel.getSelectedIdentifiers();
    }

    @Override
    public void reactToSelectedIdentifiersChanged(final SelectedIdentifiersChangedNotice evt)
    {
        _identifiersPanel.getModel().setIdentifiers(evt.getIdentifiers());
        _identifiersPanel.refreshTable();
    }

    @Override
    public void gotoUnit(final Collection<StepUnit> units)
    {
        if(units.isEmpty())
        {
            _identifiersPanel.clearSelection();
            return;
        }
        if(units.iterator().next() instanceof LocationAndDataTypeIdentifier)
        {
            _identifiersPanel.selectIdentifiers(ListTools.convertCollection(units, (LocationAndDataTypeIdentifier)null));
        }
        else
        {
            throw new IllegalArgumentException(String.format("%s not of class %s",
                                                             units.iterator().next(),
                                                             LocationAndDataTypeIdentifier.class.getCanonicalName()));
        }
    }

    @Override
    @Subscribe
    public void reactToStepStatusRefreshAll(final StepStatusRefreshAllNotice notice)
    {
        this.refreshTable();
    }
}