package ohd.hseb.hefs.mefp.pe.acceptance;

import ohd.hseb.hefs.pe.core.GenericParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepOptionsPanel;
import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.status.StatusIndicator;
import ohd.hseb.hefs.utils.status.StatusLabel;

/**
 * Processor for the Acceptance Panel
 * 
 * @author Xuning.Tan
 */
public class MEFPAcceptancePEStepProcessor extends GenericParameterEstimatorStepProcessor
{
    private final ParameterEstimatorRunInfo _runInformation;

    private final MEFPIdentifierFileHandler _fileHandler;

    public MEFPAcceptancePEStepProcessor(final ParameterEstimatorRunInfo runInfo)
    {
        _runInformation = runInfo;
        _fileHandler = new MEFPIdentifierFileHandler(_runInformation);
    }

    public ParameterEstimatorRunInfo getRunInfo()
    {
        return _runInformation;
    }

    @Override
    public void performStep(final StepUnit unit) throws Exception
    {
        // Copy parameter files over to mefpRootDir area   
        _fileHandler.copyFileOver((LocationAndDataTypeIdentifier)unit);
    }

    @Override
    public StatusIndicator getStatus(final StepUnit unit)
    {
        return StatusLabel.make(_fileHandler.getFileStatus((LocationAndDataTypeIdentifier)unit));
    }

    @Override
    public ParameterEstimatorStepOptionsPanel constructOptionsPanel()
    {
        return new MEFPAcceptancePEStepOptionsPanel(_runInformation, this);
    }

    @Override
    public String getToolTipTextDescribingStep()
    {
        return "Accept estimated parameters by placing them under mefpRootDir/parameters/.";
    }

    @Override
    public String getTabNameForStep()
    {
        return "Acceptance";
    }

    @Override
    public String getStepNameForRunButton()
    {
        return "Accept Selected";
    }

    @Override
    public String getShortNameForIdentifierTableColumn()
    {
        return "Accept";
    }

    @Override
    public String getToolTipTextForIdentifierTableColumnHeader()
    {
        return "Displays if the parameter files have been accepted.";
    }

    @Override
    public String getPerformStepPrefix()
    {
        return "Copying parameter files";
    }

}
