package ohd.hseb.hefs.mefp.pe.acceptance;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.StepTableModel;
import ohd.hseb.hefs.pe.tools.GenericSummaryTableStatusProvider;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.gui.jtable.models.RefreshTableModel;
import ohd.hseb.hefs.utils.status.StatusLabel;

/**
 * Provide Status for the parameters.
 * 
 * @author Xuning.Tan
 */
@SuppressWarnings("serial")
public class MEFPIdentifierAcceptanceTableModel extends StepTableModel implements RefreshTableModel
{
    public MEFPIdentifierAcceptanceTableModel(final ParameterEstimatorRunInfo runInfo)
    {
        super(runInfo,
              MEFPAcceptancePEStepProcessor.class,
              new FileAvailableTableStatusProvider(new MEFPIdentifierFileHandler(runInfo)),
              new IdentifierStatusProvider(new MEFPIdentifierFileHandler(runInfo)));
    }

    @Override
    public void refresh()
    {
        fireTableDataChanged();
    }

    /**
     * Provider for the Est? status column.
     */
    private static class FileAvailableTableStatusProvider implements GenericSummaryTableStatusProvider
    {
        private final MEFPIdentifierFileHandler _handler;

        private FileAvailableTableStatusProvider(final MEFPIdentifierFileHandler handler)
        {
            _handler = handler;
        }

        @Override
        public String getToolTipForColumnHeader()
        {
            return "Displays if the parameters have been estimated.";
        }

        @Override
        public String getStatusColumnName()
        {
            return "Est?";
        }

        @Override
        public StatusLabel getStatus(final LocationAndDataTypeIdentifier identifier)
        {

            /**
             * Returns the yes/no status label indicating whether parameter files exist.
             */
            if(_handler.isFileAvailable(identifier))
            {
                return StatusLabel.make(true, "<html>The parameter file is available.<br>"
                    + "Check the Estimation Panel to see if they are up-to-date.</html>");
            }
            else
            {
                return StatusLabel.make(false, "<html>The parameter file is missing.<br>"
                    + "Regenerate the parameters via the Estimation Panel in order to build the missing file.</html>");
            }
        }
    }

    /**
     * Provider for the Status column, displaying if the parameter files have been copied.
     */
    private static class IdentifierStatusProvider implements GenericSummaryTableStatusProvider
    {
        private final MEFPIdentifierFileHandler _handler;

        private IdentifierStatusProvider(final MEFPIdentifierFileHandler handler)
        {
            _handler = handler;
        }

        @Override
        public String getStatusColumnName()
        {
            return "Status";
        }

        @Override
        public String getToolTipForColumnHeader()
        {
            return "Displays if the parameter files have been copied over to mefpRootDir area.";
        }

        @Override
        public StatusLabel getStatus(final LocationAndDataTypeIdentifier identifier)
        {
            return StatusLabel.make(_handler.getFileStatus(identifier));
        }
    }
}