package ohd.hseb.hefs.mefp.pe.core;

import java.awt.Dimension;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JFrame;

import ohd.hseb.graphgen.GraphGenConductorLogAppender;
import ohd.hseb.graphgen.GraphGenEditorExplorerPlugIn;
import ohd.hseb.graphgen.core.GraphicsGeneratorProductParameters;
import ohd.hseb.hefs.utils.filechooser.HGlobalFileChooser;
import ohd.hseb.hefs.utils.xml.GenericXMLReadingHandler;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.LogManager;


public abstract class GraphGenForDiagnosticsEditingRunner
{
	
    public static void main(String[] args)
    {
        // breaks?
        //GraphGenConductor.initializeLoggerForGUIDebugging();

        final LoggerContext ctx = (LoggerContext) LogManager.getContext(false);
        final Configuration config = ctx.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder()        
                .withPattern("%d{HH:mm:ss.SSS} %level %msg%n")
                .build();
        GraphGenConductorLogAppender appender = new GraphGenConductorLogAppender("GraphGenForDiagnosticsLogAppender", layout, config);
        appender.start();
        config.addAppender(appender);
	     LoggerConfig loggerConfig = config.getLoggerConfig(LogManager.ROOT_LOGGER_NAME);
        loggerConfig.addAppender(appender, Level.INFO, null);
        config.addLogger("ohd.hseb", loggerConfig);
        ctx.updateLoggers();     	
    	
        Logger graphgenLogger = LogManager.getLogger("ohd.hseb");                      
        
        HGlobalFileChooser fileChooser = new HGlobalFileChooser(".");
        fileChooser.addFileFilter("xml", "XML File");
        fileChooser.setDialogTitle("Select Diagnostics Product File");
        File importFile = fileChooser.chooseFile(JFileChooser.FILES_ONLY, null);
        if(importFile == null)
        {
            System.exit(1);
        }
        //Load parameters from a test params.xml file.

        //Load parameters from a test params.xml file.
        GraphicsGeneratorProductParameters parameters = new GraphicsGeneratorProductParameters();
        GenericXMLReadingHandler reader = new GenericXMLReadingHandler(parameters);
        try
        {
            reader.readXMLFromFile(importFile);
        }
        catch(Exception e)
        {
            System.out.println("Unexpected exception " + e.getClass().getName() + ": " + e.getMessage());
        }

        GraphGenEditorExplorerPlugIn panel = new GraphGenEditorExplorerPlugIn(parameters);

        //Put panel in a frame.
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(new Dimension(1000, 750));
        frame.setContentPane(panel);
        frame.setVisible(true);

    }
}
