package ohd.hseb.hefs.mefp.pe.estimation;

import ohd.hseb.hefs.mefp.models.MEFPBaseModelControlOptions;
import ohd.hseb.hefs.mefp.models.MEFPParameterEstimationModel;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.mefp.sources.MEFPSourceControlOptions;
import ohd.hseb.hefs.pe.estimation.options.ControlOption;
import ohd.hseb.hefs.pe.estimation.options.ControlOptionSupplier;
import ohd.hseb.hefs.pe.estimation.options.EstimationControlOptions;
import ohd.hseb.hefs.pe.sources.ForecastSource;
import ohd.hseb.hefs.utils.tools.ParameterId.Type;

import com.google.common.collect.Iterables;

/**
 * Top level container of MEFP control parameters. Parameters are specified by an {@link MEFPParameterEstimationModel}
 * and list of {@link MEFPForecastSource} instances, all of which are {@link ControlOptionSupplier} instances.
 * 
 * @author hankherr
 */
public abstract class MEFPEstimationControlOptions extends EstimationControlOptions
{
    private Iterable<? extends MEFPForecastSource> _forecastSources;

    public MEFPEstimationControlOptions(final String xmlTag,
                                        final Iterable<? extends MEFPForecastSource> forecastSources)
    {
        super(xmlTag);
        _forecastSources = forecastSources;
    }

    protected MEFPEstimationControlOptions(final Type type,
                                           final String xmlTag,
                                           final MEFPParameterEstimationModel model,
                                           final Iterable<? extends MEFPForecastSource> forecastSources)
    {
        super(type, xmlTag, model, forecastSources);
        _forecastSources = forecastSources;
    }

    public Iterable<? extends MEFPForecastSource> getForecastSources()
    {
        return _forecastSources;
    }

    public MEFPSourceControlOptions getSourceControlOptions(final ForecastSource forecastSource)
    {
        return (MEFPSourceControlOptions)super.getControlOptions(forecastSource);
    }

    public void removeSourceControlOptions(final MEFPForecastSource source)
    {
        super.removeControlOptions(source);
    }

    public MEFPSourceControlOptions getSourceControlOptions(final int index)
    {
        return getSourceControlOptions(Iterables.get(_forecastSources, index));
    }

    @Override
    public MEFPParameterEstimationModel getModel()
    {
        return (MEFPParameterEstimationModel)super.getModel();
    }

    @Override
    public MEFPBaseModelControlOptions getModelParameters()
    {
        return (MEFPBaseModelControlOptions)super.getModelParameters();
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        _forecastSources = ((MEFPEstimationControlOptions)base).getForecastSources();
        super.copyFrom(base);
    }

    @Override
    public MEFPEstimationControlOptions clone()
    {
        return (MEFPEstimationControlOptions)super.clone();

    }
}
