package ohd.hseb.hefs.mefp.pe.estimation;

import ohd.hseb.hefs.mefp.models.precipitation.MEFPPrecipitationModelControlOptions;
import ohd.hseb.hefs.mefp.models.precipitation.PrecipitationParameterEstimationModel;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.pe.model.AlgorithmModelParameters;
import ohd.hseb.hefs.utils.tools.ParameterId;

public class MEFPPrecipitationEstimationControlOptions extends MEFPEstimationControlOptions
{
    public MEFPPrecipitationEstimationControlOptions(final Iterable<? extends MEFPForecastSource> sources)
    {
        super("mefppePrecipitationControlOptions", sources);
    }

    public MEFPPrecipitationEstimationControlOptions(final PrecipitationParameterEstimationModel model,
                                                     final Iterable<? extends MEFPForecastSource> sources)
    {
        super(ParameterId.Type.PRECIPITATION, "mefppePrecipitationControlOptions", model, sources);
    }

    @Override
    public MEFPPrecipitationModelControlOptions getModelParameters()
    {
        return (MEFPPrecipitationModelControlOptions)super.getModelParameters();
    }

    @Override
    public PrecipitationParameterEstimationModel getModel()
    {
        return (PrecipitationParameterEstimationModel)super.getModel();
    }

    @Override
    public MEFPEstimationControlOptions clone()
    {
        final MEFPPrecipitationEstimationControlOptions copy = new MEFPPrecipitationEstimationControlOptions(getForecastSources());
        copy.copyFrom(this);
        return copy;
    }

    @Override
    public void populateAlgorithmModelParameters(final AlgorithmModelParameters algorithmParameters)
    {
    }

}
