package ohd.hseb.hefs.mefp.pe.estimation;

import ohd.hseb.hefs.mefp.models.temperature.TemperatureParameterEstimationModel;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.utils.tools.ParameterId;

public class MEFPTemperatureEstimationControlOptions extends MEFPEstimationControlOptions
{
    public MEFPTemperatureEstimationControlOptions(final Iterable<? extends MEFPForecastSource> sources)
    {
        super("mefppeTemperatureControlOptions", sources);
    }

    public MEFPTemperatureEstimationControlOptions(final TemperatureParameterEstimationModel model,
                                                   final Iterable<? extends MEFPForecastSource> sources)
    {
        super(ParameterId.Type.TEMPERATURE, "mefppeTemperatureControlOptions", model, sources);
    }

    @Override
    public TemperatureParameterEstimationModel getModel()
    {
        return (TemperatureParameterEstimationModel)super.getModel();
    }

    @Override
    public MEFPEstimationControlOptions clone()
    {
        final MEFPTemperatureEstimationControlOptions copy = new MEFPTemperatureEstimationControlOptions(getForecastSources());
        copy.copyFrom(this);
        return copy;
    }

    //XXX This class does not override populateAlgorithmModelParameters because the algorithm model parameters do not make use of 
    //_nparint.  It uses a hard coded 5 day window.
}
