package ohd.hseb.hefs.mefp.pe.estimation.diag;

import java.util.Collection;

import ohd.hseb.hefs.mefp.tools.canonical.CanonicalEvent;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * An event indicating a selection of canonical events. The selected events can be acquired by calling
 * {@link #getSelectedEvents()}. Implement the interface {@link Subscriber} to hear the events (i.e.,
 * "CanonicalEventsSelectedNotice.Subscriber").
 * 
 * @author hankherr
 */
public class CanonicalEventsSelectedNotice extends Notice
{
    private final Collection<CanonicalEvent> _selectedEvents;

    /**
     * @param source The source of the event.
     * @param selectedEvents The events that are now selected.
     */
    public CanonicalEventsSelectedNotice(final Object source, final Collection<CanonicalEvent> selectedEvents)
    {
        super(source);
        _selectedEvents = selectedEvents;

    }

    public Collection<CanonicalEvent> getSelectedEvents()
    {
        return _selectedEvents;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToCanonicalEventsSelected(CanonicalEventsSelectedNotice evt);
    }
}
