package ohd.hseb.hefs.mefp.pe.estimation.diag;

import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * This notice is fired by a {@link ParameterQCDiagnosticPanel} whenever the user clicks on the button to create the
 * block plot for selected locations.
 * 
 * @author hankherr
 */
public class CreateBlockPlotForSelectedLocationsNotice extends Notice
{

    public CreateBlockPlotForSelectedLocationsNotice(final ParameterQCDiagnosticPanel source)
    {
        super(source);
    }

    /**
     * Overridden to cast the return into a {@link ParameterQCDiagnosticPanel}.
     */
    @Override
    public ParameterQCDiagnosticPanel getSource()
    {
        return (ParameterQCDiagnosticPanel)super.getSource();
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToCreateBlockPlotForSelectedLocationsNotice(CreateBlockPlotForSelectedLocationsNotice evt);
    }

}
