package ohd.hseb.hefs.mefp.pe.estimation.diag;

import java.io.File;

import ohd.hseb.hefs.mefp.models.parameters.MEFPFullModelParameters;
import ohd.hseb.hefs.pe.core.GenericParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepOptionsPanel;
import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.pe.gui.PerformAllStepsJob;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.jobs.JobMessenger;
import ohd.hseb.hefs.utils.tools.FileTools;

/**
 * Step is used within a {@link PerformAllStepsJob} in order to create block plot images for many locations. Most
 * methods return null or filler.
 * 
 * @author hankherr
 */
public class CreateParameterBlockDiagnosticStepProcessor extends GenericParameterEstimatorStepProcessor
{

    /**
     * The panel specifying the instructions for building the diagnostic plot.
     */
    private final ParameterQCDiagnosticPanel _blockChartGenerator;

    /**
     * Output directory where files will be written.
     */
    private final File _outputDirectory;

    /**
     * The file name prefix of each geneated file.
     */
    private final String _fileNamePrefix;

    /**
     * The method {@link ParameterEstimatorRunInfo#getEstimatedParametersFileHandler()} is called to acquire a handler
     * for reading parameters.
     */
    private final ParameterEstimatorRunInfo _runInfo;

    public CreateParameterBlockDiagnosticStepProcessor(final ParameterEstimatorRunInfo runInfo,
                                                       final ParameterQCDiagnosticPanel blockChartGenerator,
                                                       final File outputDirectory,
                                                       final String fileNamePrefix)
    {
        _runInfo = runInfo;
        _blockChartGenerator = blockChartGenerator;
        _outputDirectory = outputDirectory;
        _fileNamePrefix = fileNamePrefix;
    }

    @Override
    public ParameterEstimatorStepOptionsPanel constructOptionsPanel()
    {
        return null;
    }

    @Override
    public void performStep(final StepUnit unit) throws Exception
    {
        JobMessenger.setIndeterminate(true);
        try
        {
            final LocationAndDataTypeIdentifier identifier = (LocationAndDataTypeIdentifier)unit;

            JobMessenger.updateNote("Reading parameters for " + identifier.buildStringToDisplayInTree() + "...");
            final MEFPFullModelParameters parameters = (MEFPFullModelParameters)_runInfo.getEstimatedParametersFileHandler()
                                                                                        .readModelParameters(identifier);

            JobMessenger.updateNote("Generate diagnostic block plot image file for "
                + identifier.buildStringToDisplayInTree() + "...");
            File imageFile;
            if(_fileNamePrefix.isEmpty())
            {
                imageFile = FileTools.newFile(_outputDirectory,
                                              identifier.getLocationId() + "." + identifier.getParameterId() + ".png");
            }
            else
            {
                imageFile = FileTools.newFile(_outputDirectory, _fileNamePrefix + "." + identifier.getLocationId()
                    + "." + _blockChartGenerator.getSelectedParameterDataType() + ".png");
            }
            _blockChartGenerator.createDiagnosticChart(parameters, imageFile);

            JobMessenger.updateNote("Done generating image file.");
        }
        finally
        {
            JobMessenger.clearMonitorSubJob();
        }
    }

    @Override
    public String getTabNameForStep()
    {
        return "Create Block Plots";
    }

    @Override
    public String getStepNameForRunButton()
    {
        return "Create Parameter Diagnostics Block Plots";
    }

    @Override
    public String getShortNameForIdentifierTableColumn()
    {
        return "BLOCK";
    }

    @Override
    public String getToolTipTextForIdentifierTableColumnHeader()
    {
        return null;
    }

    @Override
    public String getPerformStepPrefix()
    {
        return "Generating parameter diagnostic plot ";
    }

    @Override
    public boolean concurrencySupported()
    {
        return false;
    }

}
