package ohd.hseb.hefs.mefp.pe.estimation.diag;

import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.pe.model.ModelParameterType;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * An event indicating a selection of parameter data types. The selected types can be acquired by calling
 * {@link #getSelectedTypes()}. Implement the interface {@link Subscriber} to hear the events (i.e.,
 * "DisplayedParameterSelectedNotice.Subscriber").
 * 
 * @author hankherr
 */
public class DisplayedParameterSelectedNotice extends Notice
{
    private final ModelParameterType[] _selectedTypes;
    private final MEFPForecastSource _selectedAlternateSource;

    /**
     * @param source The source of the event.
     * @param selectedEvents The events that are now selected.
     */
    public DisplayedParameterSelectedNotice(final Object source,
                                            final ModelParameterType[] selectedTypes,
                                            final MEFPForecastSource selectedAlternateSource)
    {
        super(source);
        _selectedTypes = selectedTypes;
        _selectedAlternateSource = selectedAlternateSource;
    }

    public ModelParameterType[] getSelectedTypes()
    {
        return _selectedTypes;
    }

    public MEFPForecastSource getSelectedAlternateSource()
    {
        return _selectedAlternateSource;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToDisplayedParameterSelected(DisplayedParameterSelectedNotice evt);
    }
}
