package ohd.hseb.hefs.mefp.pe.estimation.diag;

import java.awt.Color;
import java.util.Date;

import ohd.hseb.charter.datasource.instances.DataSetXYChartDataSource;
import ohd.hseb.charter.panel.AbstractChartEngineTableModel;
import ohd.hseb.hefs.utils.Dyad;
import ohd.hseb.util.data.DataSet;

/**
 * Makes use of the {@link DataSet} contained within the return of {@link #getCurrentDataSource()}, which must be a
 * {@link DataSetXYChartDataSource}. That data is constructed within {@link EventDaySummaryDiagnostic} and stored as an
 * attribute. In addition to the two standard scatter plot columns, a third date column is displayed showing the
 * Forecast T0 for each event.
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class EventDaySummaryTableModel extends AbstractChartEngineTableModel
{

    @Override
    public String getColumnName(final int col)
    {
        if(col == 2)
        {
            return "Forecast T0 (GMT)";
        }
        return super.getColumnName(col);
    }

    @Override
    public Object getRawValueAt(final int modelRow, final int modelColumn)
    {
        if(modelColumn != 2)
        {
            return super.getRawValueAt(modelRow, modelColumn);
        }

        //The data must correspond to that constructed in 
        final DataSet displayData = ((DataSetXYChartDataSource)getCurrentDataSource()).getData();
        return new Date((long)displayData.getValue(modelRow, 2));
    }

    @Override
    public Class<?> getColumnClass(final int col)
    {
        if(col == 2)
        {
            return Date.class;
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getColumnCount()
    {
        return super.getColumnCount() + 1;
    }

    @Override
    public Dyad<Color, Integer> getColumnMarkColor(final int modelCol)
    {
        if(modelCol == 2)
        {
            return null;
        }
        return super.getColumnMarkColor(modelCol);
    }

    @Override
    public int computeSeriesIndex(final int modelColumn)
    {
        return 0; //Only one series is ever displayed in this table!
    }
}
