package ohd.hseb.hefs.mefp.pe.estimation.diag;

import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * An event indicating a selection of parameter data types. The selected types can be acquired by calling
 * {@link #getSelectedSource()}. Implement the interface {@link Subscriber} to hear the events (i.e.,
 * "ForecastSourceSelectedNotice.Subscriber").
 * 
 * @author hankherr
 */
public class ForecastSourceSelectedNotice extends Notice
{
    private final MEFPForecastSource _selectedSource;

    /**
     * @param source The source of the event.
     * @param selectedEvents The events that are now selected.
     */
    public ForecastSourceSelectedNotice(final Object source, final MEFPForecastSource selectedSource)
    {
        super(source);
        _selectedSource = selectedSource;

    }

    public MEFPForecastSource getSelectedSource()
    {
        return _selectedSource;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToForecastSourceSelected(ForecastSourceSelectedNotice evt);
    }
}
