package ohd.hseb.hefs.mefp.pe.estimation.diag;

import ohd.hseb.hefs.mefp.models.MEFPModelTools;
import ohd.hseb.hefs.mefp.models.parameters.MEFPFullModelParameters;
import ohd.hseb.hefs.mefp.models.parameters.MEFPSourceModelParameters;
import ohd.hseb.hefs.mefp.models.precipitation.MEFPPrecipitationModelControlOptions;
import ohd.hseb.hefs.mefp.tools.canonical.CanonicalEvent;
import ohd.hseb.hefs.mefp.tools.canonical.StandardCanonicalEventValuesGatherer;

@SuppressWarnings("serial")
public class PrecipitationEventDaySummaryPanel extends EventDaySummaryPanel
{
    private final StandardCanonicalEventValuesGatherer _iptGatherer;
    private StandardCanonicalEventValuesGatherer _eptGatherer = null;

    /**
     * @param fullParameters All the parameters.
     * @param sourceParameters The source parameters specifying the source to focus on.
     * @param event Event for which a summary is to be provided.
     * @param dayOfYear The day of the year for which a summary is to be provided.
     * @throws Exception
     */
    public PrecipitationEventDaySummaryPanel(final MEFPFullModelParameters fullParameters,
                                             final MEFPSourceModelParameters sourceParameters,
                                             final CanonicalEvent event,
                                             final int dayOfYear) throws Exception
    {
        _iptGatherer = (StandardCanonicalEventValuesGatherer)sourceParameters.getForecastSource()
                                                                             .constructCanonicalEventValuesGatherer(sourceParameters.getPrecipitationSourceEventValues(),
                                                                                                                    fullParameters.getEstimationControlOptions()
                                                                                                                                  .getModelParameters(),
                                                                                                                    fullParameters.getEstimationControlOptions()
                                                                                                                                  .getSourceControlOptions(sourceParameters.getForecastSource()));

        if(sourceParameters.getForecastSource().canEPTModelBeUsedForSource())
        {
            _eptGatherer = MEFPModelTools.constructEPTCanonicalEventValuesGatherer(sourceParameters.getForecastSource(),
                                                                                   sourceParameters.getPrecipitationSourceEventValues(),
                                                                                   (MEFPPrecipitationModelControlOptions)fullParameters.getEstimationControlOptions()
                                                                                                                                       .getModelParameters(),
                                                                                   fullParameters.getEstimationControlOptions()
                                                                                                 .getSourceControlOptions(sourceParameters.getForecastSource()));
        }
        initialize(sourceParameters, fullParameters, event, dayOfYear);

        //XXX CHECKING -- this check passed before
//        System.err.println("####>> CHECKING1 -- "
//            + _iptGatherer.getLastComputedObservedThreshold(_event)
//            + " =? "
//            + _sourceParameters.getParameterValues(new PThreshParameterType(HEFSTools.DEFAULT_PRECIPITATION_IDENTIFIER_PARAMETER_ID,
//                                                                            false))
//                               .getValue(_dayOfYear, _event));
//        System.err.println("####>> CHECKING2 -- "
//            + _iptGatherer.getLastComputedForecastThreshold(_event)
//            + " =? "
//            + _sourceParameters.getParameterValues(new PThreshParameterType(HEFSTools.DEFAULT_PRECIPITATION_IDENTIFIER_PARAMETER_ID,
//                                                                            true))
//                               .getValue(_dayOfYear, _event));

        initializeEventDaySummaryDiagnostics();
    }

    @Override
    protected void initializeEventDaySummaryDiagnostics()
    {
        if(getSourceParameters().getForecastSource().canEPTModelBeUsedForSource())
        {
            addDiagnostic(new EPTScatterEventDaySummaryDiagnostic(getFullParameters(),
                                                                  getSourceParameters(),
                                                                  getEvent(),
                                                                  getDayOfYear(),
                                                                  _eptGatherer));
        }
        addDiagnostic(new DistributionEventDaySummaryDiagnostic(getFullParameters(),
                                                               getSourceParameters(),
                                                               getEvent(),
                                                               getDayOfYear(),
                                                               _eptGatherer,
                                                               true,
                                                               true));
        addDiagnostic(new DistributionEventDaySummaryDiagnostic(getFullParameters(),
                                                               getSourceParameters(),
                                                               getEvent(),
                                                               getDayOfYear(),
                                                               _eptGatherer,
                                                               false,
                                                               true));
        addDiagnostic(new DistributionEventDaySummaryDiagnostic(getFullParameters(),
                                                               getSourceParameters(),
                                                               getEvent(),
                                                               getDayOfYear(),
                                                               _eptGatherer,
                                                               true,
                                                               false));
        addDiagnostic(new IPTScatterEventDaySummaryDiagnostic(getFullParameters(),
                                                              getSourceParameters(),
                                                              getEvent(),
                                                              getDayOfYear(),
                                                              _iptGatherer));
    }
}
