package ohd.hseb.hefs.mefp.pe.estimation.diag;

import java.awt.Color;
import java.awt.Font;

import ohd.hseb.charter.ChartEngine;
import ohd.hseb.charter.ChartConstants;
import ohd.hseb.charter.datasource.XYChartDataSource;
import ohd.hseb.charter.datasource.instances.DataSetXYChartDataSource;
import ohd.hseb.charter.parameters.SeriesDrawingParameters;
import ohd.hseb.charter.parameters.ThresholdParameters;
import ohd.hseb.hefs.mefp.models.parameters.MEFPFullModelParameters;
import ohd.hseb.hefs.mefp.models.parameters.MEFPSourceModelParameters;
import ohd.hseb.hefs.mefp.tools.canonical.CanonicalEvent;
import ohd.hseb.hefs.mefp.tools.canonical.StandardCanonicalEventValuesGatherer;
import ohd.hseb.hefs.utils.tools.ParameterId;

import com.google.common.collect.Lists;

public class TempScatterEventDaySummaryDiagnostic extends EventDaySummaryDiagnostic
{
    private final ParameterId _parameterId;

    public TempScatterEventDaySummaryDiagnostic(final MEFPFullModelParameters fullParameters,
                                                final MEFPSourceModelParameters sourceParameters,
                                                final CanonicalEvent event,
                                                final int dayOfYear,
                                                final StandardCanonicalEventValuesGatherer gatherer,
                                                final ParameterId parameterId)
    {
        initialize(fullParameters, sourceParameters, event, dayOfYear, gatherer);
        _parameterId = parameterId;
        buildDisplayData(2);
    }

    @Override
    public ChartEngine buildDiagnosticChartEngine() throws Exception
    {
        final DataSetXYChartDataSource dataSource = new DataSetXYChartDataSource(null,
                                                                                 0,
                                                                                 getDisplayData(),
                                                                                 new int[]{0},
                                                                                 new int[]{1});
        dataSource.setSourceNameInTable(this._parameterId + ": Scatter Plot of Forecast Against Observed");
        dataSource.addChartTableColumnHeader(0, "Forecast");
        dataSource.setDomainHeader("Observed");

        final ChartEngine engine = new ChartEngine(Lists.newArrayList((XYChartDataSource)dataSource));
        engine.getChartParameters().getDataSourceParameters(0).setPlotterName("LineAndScatter");
        final SeriesDrawingParameters seriesParms = engine.getChartParameters()
                                                          .getDataSourceParameters(0)
                                                          .getSeriesDrawingParametersForSeriesIndex(0);
        seriesParms.setLineWidth(0.0f);
        seriesParms.setShapeName("circle");
        seriesParms.setShapeFilled(true);
        seriesParms.setFillColor(seriesParms.getLineColor());
        seriesParms.setShapeSize(1.0d);

        //The variable value displays the correlation coefficient.  For climatology, the correlation coefficient is assumed to be 1.
        //Correlation is displayed only if this is for a specific day-of-year.
        double value = 1.0d;
        if(getDayOfYear() > 0)
        {
            if(!getSourceParameters().getForecastSource().isClimatologySource())
            {
                if(_parameterId.isMax())
                {
                    value = this.getSourceParameters().getTMAXRhoParameterValue(getDayOfYear(), getEvent());
                }
                else
                {
                    value = this.getSourceParameters().getTMINRhoParameterValue(getDayOfYear(), getEvent());
                }
            }
        }

        //Determine the window width used to gather values.
        String windowWidthUsedForGathering = "";
        if(getDayOfYear() > 0)
        {
            windowWidthUsedForGathering = "Window Width Used to Gather Events = "
                + getGatherer().getWindowWidthUsedForGatheredValues(getEvent()) + " Days";
            if(getGatherer().getWindowWidthUsedForGatheredValues(getEvent()) < 0)
            {
                windowWidthUsedForGathering = "Window Width Used to Gather Events = "
                    + getGatherer().getMaximumWindowWidth() + " Days (not enough data found)";
            }
        }

        String titleText = _parameterId.toString() + " -- Scatter Plot of Forecast Against Observed";
        if(getDayOfYear() > 0)
        {
            titleText += " (Correlation = " + value + ")\n" + windowWidthUsedForGathering;
        }

        engine.getChartParameters().getPlotTitle().setText(titleText);
        engine.getChartParameters().getPlotTitle().setFont(new Font("Serif", Font.BOLD, 14));
        engine.getChartParameters().getDomainAxis().getLabel().setText("Observed Canonical Event Value [DegC]"); //Temp is always MM units in MEFP
        engine.getChartParameters()
              .getSubPlot(0)
              .getLeftAxis()
              .getLabel()
              .setText("Forecast Canonical Event Value [DegC]");

        ThresholdParameters threshold = new ThresholdParameters("Fcst Freeze");
        threshold.setIncludeInAxisLimitsComputation(false);
        threshold.setVisible(true);
        threshold.setupDefaultParameters();
        threshold.setNumericalAxisValueStartStr("0.0");
        threshold.getLabel().setText("Freezing");
        threshold.setLabelAnchor("top_right");
        threshold.setLineWidth(2.0f);
        threshold.setColor(Color.BLUE);
        engine.getChartParameters().getThresholdList().addThreshold(threshold);

        threshold = new ThresholdParameters("Obs Freeze");
        threshold.setIncludeInAxisLimitsComputation(false);
        threshold.setVisible(true);
        threshold.setupDefaultParameters();
        threshold.setNumericalAxisValueStartStr("0.0");
        threshold.getLabel().setText("Freezing");
        threshold.setLabelAnchor("top_right");
        threshold.setLineWidth(2.0f);
        threshold.setColor(Color.BLUE);
        threshold.setAxisIdString(ChartConstants.DOMAIN_AXIS_STRING);
        engine.getChartParameters().getThresholdList().addThreshold(threshold);

        return engine;
    }

    @Override
    public String toString()
    {
        return _parameterId + ": Scatter Plot of Raw Forecast Against Observed Values";
    }

}
