package ohd.hseb.hefs.mefp.pe.estimation.diag;

import ohd.hseb.hefs.mefp.models.parameters.MEFPFullModelParameters;
import ohd.hseb.hefs.mefp.models.parameters.MEFPSourceModelParameters;
import ohd.hseb.hefs.mefp.tools.canonical.CanonicalEvent;
import ohd.hseb.hefs.mefp.tools.canonical.StandardCanonicalEventValuesGatherer;
import ohd.hseb.hefs.utils.tools.ParameterId;

@SuppressWarnings("serial")
public class TemperatureEventDaySummaryPanel extends EventDaySummaryPanel
{
    private final StandardCanonicalEventValuesGatherer _tminGatherer;
    private final StandardCanonicalEventValuesGatherer _tmaxGatherer;

    /**
     * @param fullParameters All the parameters.
     * @param sourceParameters The source parameters specifying the source to focus on.
     * @param event Event for which a summary is to be provided.
     * @param dayOfYear The day of the year for which a summary is to be provided.
     * @throws Exception
     */
    public TemperatureEventDaySummaryPanel(final MEFPFullModelParameters fullParameters,
                                           final MEFPSourceModelParameters sourceParameters,
                                           final CanonicalEvent event,
                                           final int dayOfYear,
                                           final ParameterId parameterId) throws Exception
    {
        _tminGatherer = (StandardCanonicalEventValuesGatherer)sourceParameters.getForecastSource()
                                                                              .constructCanonicalEventValuesGatherer(sourceParameters.getTMINSourceEventValues(),
                                                                                                                     fullParameters.getEstimationControlOptions()
                                                                                                                                   .getModelParameters(),
                                                                                                                     fullParameters.getEstimationControlOptions()
                                                                                                                                   .getSourceControlOptions(sourceParameters.getForecastSource()));

        _tmaxGatherer = (StandardCanonicalEventValuesGatherer)sourceParameters.getForecastSource()
                                                                              .constructCanonicalEventValuesGatherer(sourceParameters.getTMAXSourceEventValues(),
                                                                                                                     fullParameters.getEstimationControlOptions()
                                                                                                                                   .getModelParameters(),
                                                                                                                     fullParameters.getEstimationControlOptions()
                                                                                                                                   .getSourceControlOptions(sourceParameters.getForecastSource()));

        //XXX CHECKING
//        System.err.println("####>> CHECKING1 -- "
//            + _iptGatherer.getLastComputedObservedThreshold(_event)
//            + " =? "
//            + _sourceParameters.getParameterValues(new PThreshParameterType(HEFSTools.DEFAULT_PRECIPITATION_IDENTIFIER_PARAMETER_ID,
//                                                                            false))
//                               .getValue(_dayOfYear, _event));
//        System.err.println("####>> CHECKING2 -- "
//            + _iptGatherer.getLastComputedForecastThreshold(_event)
//            + " =? "
//            + _sourceParameters.getParameterValues(new PThreshParameterType(HEFSTools.DEFAULT_PRECIPITATION_IDENTIFIER_PARAMETER_ID,
//                                                                            true))
//                               .getValue(_dayOfYear, _event));

        initialize(sourceParameters, fullParameters, event, dayOfYear);
    }

    @Override
    protected void initializeEventDaySummaryDiagnostics()
    {
        addDiagnostic(new TempScatterEventDaySummaryDiagnostic(getFullParameters(),
                                                               getSourceParameters(),
                                                               getEvent(),
                                                               getDayOfYear(),
                                                               _tminGatherer,
                                                               ParameterId.TMIN));
        addDiagnostic(new DistributionEventDaySummaryDiagnostic(getFullParameters(),
                                                                getSourceParameters(),
                                                                getEvent(),
                                                                getDayOfYear(),
                                                                _tminGatherer));

        addDiagnostic(new TempScatterEventDaySummaryDiagnostic(getFullParameters(),
                                                               getSourceParameters(),
                                                               getEvent(),
                                                               getDayOfYear(),
                                                               _tmaxGatherer,
                                                               ParameterId.TMAX));
        addDiagnostic(new DistributionEventDaySummaryDiagnostic(getFullParameters(),
                                                                getSourceParameters(),
                                                                getEvent(),
                                                                getDayOfYear(),
                                                                _tmaxGatherer));
    }
}
