package ohd.hseb.hefs.mefp.pe.setup;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.JTable;

import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.sources.historical.HistoricalDataHandler;
import ohd.hseb.hefs.pe.tools.GenericSummaryTableModel;
import ohd.hseb.hefs.pe.tools.GenericSummaryTableStatusProvider;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.status.StatusLabel;
import ohd.hseb.hefs.utils.tools.ListTools;

public class HistoricalLocationSummaryTableModel extends GenericSummaryTableModel
{
    private static final long serialVersionUID = 1L;

    public static String NO_MAPPED_STATION_ID = "-none-";

    private final HistoricalDataHandler _handler;

    private JTable _containingTable = null;
    private final List<Boolean> _checkedState = new ArrayList<Boolean>();

    public HistoricalLocationSummaryTableModel(MEFPParameterEstimatorRunInfo runInfo)
    {
        super(runInfo, new Provider());

        ((Provider)super.getProviders().get(0)).setHolder(this);

        _handler = runInfo.getHistoricalDataHandler();
    }

    public String buildPathName(LocationAndDataTypeIdentifier identifier)
    {
        return identifier.getLocationId() + "." + identifier.getParameterId() + ".fi";
    }

    public void checkSelected()
    {
        int[] selectedRows = this._containingTable.getSelectedRows();
        for(int i: selectedRows)
        {
            this._checkedState.set(i, true);
        }
        this.fireTableDataChanged();
    }

    public void uncheckSelected()
    {
        int[] selectedRows = this._containingTable.getSelectedRows();
        for(int i: selectedRows)
        {
            this._checkedState.set(i, false);
        }
        this.fireTableDataChanged();
    }

    public void checkAll()
    {
        ListTools.setAll(_checkedState, true);
        this.fireTableDataChanged();
    }

    public void uncheckAll()
    {
        ListTools.setAll(_checkedState, false);
        this.fireTableDataChanged();
    }

    public void setContainingTable(JTable table)
    {
        _containingTable = table;
    }

    public List<LocationAndDataTypeIdentifier> getIdentifiersToExport()
    {
        ArrayList<LocationAndDataTypeIdentifier> identifiers = new ArrayList<LocationAndDataTypeIdentifier>();
        for(int i = 0; i < _checkedState.size(); i++)
        {
            if(_checkedState.get(i))
            {
                identifiers.add(this.getIdentifier(i));
            }
        }
        return identifiers;
    }

    @Override
    public void setIdentifiers(Collection<LocationAndDataTypeIdentifier> identifiers)
    {
        super.setIdentifiers(identifiers);
        for(int i = 0; i < getRowCount(); i++)
        {
            _checkedState.add(false);
        }
    }

    @Override
    public int getColumnCount()
    {
        //Will not display coordinate columns, since coordinates are not known when this is displayed.
        return 6;
    }

    @Override
    public String getColumnName(int column)
    {
        if(column == 5)
        {
            return "Export?";
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(int row, int column)
    {
        if(column == 5)
        {
            return this._checkedState.get(row);
        }
        return super.getValueAt(row, column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex)
    {
        if(columnIndex == 5)
        {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex)
    {
        if(columnIndex == 5)
        {
            this._checkedState.set(rowIndex, (Boolean)aValue);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column)
    {
        return (column == 5);
    }

    private static class Provider implements GenericSummaryTableStatusProvider
    {
        private HistoricalLocationSummaryTableModel _holder;

        private void setHolder(HistoricalLocationSummaryTableModel holder)
        {
            _holder = holder;
        }

        @Override
        public String getStatusColumnName()
        {
            return "Found?";
        }

        @Override
        public String getToolTipForColumnHeader()
        {
            return "Indicates if an exported historical file already contains the location and data type.";
        }

        @Override
        public StatusLabel getStatus(LocationAndDataTypeIdentifier identifier)
        {
            File checkFile = new File(_holder._handler.buildFullPathNameForPIXMLFileFromFileName(_holder.buildPathName(identifier)));
            boolean b = (checkFile.exists()) || (_holder._handler.getIdentifiersWithData().contains(identifier));
            if(b)
            {
                return StatusLabel.make(true, "An exported historical data file was found containing data for "
                    + identifier.buildStringToDisplayInTree());
            }
            else
            {
                return StatusLabel.make(false, "No exported historical data file was found containing data for "
                    + identifier.buildStringToDisplayInTree());
            }
        }
    };
}
