package ohd.hseb.hefs.mefp.pe.setup;

import java.awt.BorderLayout;

import javax.swing.JTabbedPane;

import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.mefp.sources.plugin.PluginForecastSource;
import ohd.hseb.hefs.mefp.sources.plugin.PluginSetupPanel;
import ohd.hseb.hefs.pe.gui.PESetupPanel;
import ohd.hseb.hefs.pe.notice.AvailableIdentifiersChangedNotice;
import ohd.hseb.hefs.pe.setup.ExportPIXMLPanel;
import ohd.hseb.hefs.utils.gui.help.HelpFile;

import com.google.common.eventbus.Subscribe;

/**
 * PESetupPanel implementation for the MEFPPE.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
@HelpFile("PDFHELP:helpManual.pdf#SetupSubpanelRef")
public class MEFPPESetupPanel extends PESetupPanel implements AvailableIdentifiersChangedNotice.Subscriber
{
    private JTabbedPane _tabbedPanel;
    private ExportPIXMLPanel _exportPanel;
    private CanonicalEventPanel _eventPanel;

    private final String _diagnosticGraphGenTemplateFilename = "mefppe/diagnostics/exportPIXMLDisplayDiagnostics.xml";

    public MEFPPESetupPanel(final MEFPParameterEstimatorRunInfo runInfo)
    {
        super(runInfo);
    }

    @Override
    public MEFPParameterEstimatorRunInfo getRunInfo()
    {
        return (MEFPParameterEstimatorRunInfo)super.getRunInfo();
    }

    @Override
    protected void initializeDisplay()
    {
        getRunInfo().register(this);
        setLayout(new BorderLayout());

        _tabbedPanel = new JTabbedPane();

        _exportPanel = new ExportPIXMLPanel(getRunInfo(),
                                            null,
                                            getRunInfo().getHistoricalDataHandler(),
                                            _diagnosticGraphGenTemplateFilename);
        _tabbedPanel.addTab("Export Historical Data", _exportPanel);

        _eventPanel = new CanonicalEventPanel(getRunInfo());
        _tabbedPanel.addTab("Canonical Events", _eventPanel);

        //TODO Need to put all plug-in sources into one Plugin Reforecast Preparation Panel.
        for(final MEFPForecastSource source: getRunInfo().getForecastSources())
        {
            if(source instanceof PluginForecastSource)
            {
                final PluginSetupPanel panel = new PluginSetupPanel(getRunInfo(), (PluginForecastSource)source);
                _tabbedPanel.addTab("Prepare " + ((PluginForecastSource)source).getSourceId(), panel);
            }
        }

        this.add(_tabbedPanel, BorderLayout.CENTER);
    }

    @Override
    @Subscribe
    public void reactToAvailableIdentifiersChanged(final AvailableIdentifiersChangedNotice notice)
    {
        //There is nothing to do here at the moment because station mapping was removed, but I'll leave it for future reference.
    }

}
