package ohd.hseb.hefs.mefp.sources;

import ohd.hseb.hefs.pe.estimation.options.ControlOption;

/**
 * Extension of {@link ControlOption} adds methods common to all forecast sources. Note that the enabled flag indicates
 * if the source is to be used. parameter instances.
 * 
 * @author hank.herr
 */
public interface MEFPSourceControlOptions<T> extends ControlOption<T>, Cloneable
{
    /**
     * @return The number of forecast days used for the type of forecast source.
     */
    int getNumberOfForecastDaysUsed();

    /**
     * @return The initial year to use for estimating parameters. A negative return indicates the year is to be
     *         determined from the data.
     */
    int getInitialYear();

    /**
     * @return The last year to use for estimating parameters. A negative return indicates the year is to be determined
     *         from the data.
     */
    int getFinalYear();

    /**
     * @return if this set of parameters is enabled
     */
    boolean isEnabled();

    /**
     * Set whether or not to use these parameters.
     */
    void setEnabled(boolean enabled);

    /**
     * @return True if the source is used in parameter estimation; i.e., it is enabled and the number of days is
     *         positive.
     */
    public boolean isSourceUsedInParameterEstimation();
}
