package ohd.hseb.hefs.mefp.sources.cfsv2;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.charter.ChartEngine;
import ohd.hseb.charter.datasource.XYChartDataSource;
import ohd.hseb.charter.datasource.instances.TimeSeriesArraysXYChartDataSource;
import ohd.hseb.charter.panel.AbstractChartEngineTableModel;
import ohd.hseb.charter.panel.DomainSharingTimeSeriesChartEngineTableModel;
import ohd.hseb.hefs.pe.tools.TimeSeriesChartDiagnosticTableModel;

/**
 * Extension of {@link TimeSeriesChartDiagnosticTableModel} and, therefore,
 * {@link DomainSharingTimeSeriesChartEngineTableModel}, that undoes the domain sharing features by calling the top
 * level {@link AbstractChartEngineTableModel} version of the methods. For CFSv2 monthly data, the times of each
 * reforecast are not shared, because the time steps are 30-days, not 6-hours, while forecast times (and therefore start
 * times) will differ by 6-hours. Hence, this class overrides those methods that took advantage of sharing the same
 * domain, making it so that each reforecast series is displayed independently in the table using two columns (time,
 * value), while ensemble members will use a single column, as per the default abstract mechanism (i.e., it auto detects
 * it).<br>
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class CFSv2MonthlyChartDiagnosticTableModel extends TimeSeriesChartDiagnosticTableModel
{

    @Override
    public void setChartEngineWithoutFiringEvent(final ChartEngine engine)
    {
        for(final XYChartDataSource source: engine.getDataSources())
        {
            if(!(source instanceof TimeSeriesArraysXYChartDataSource))
            {
                throw new IllegalArgumentException("At least once source within the provided chart engine is not a TimeSeriesArraysXYChartDataSource.");
            }
        }
        abstractSetChartEngineWithoutFiringEvent(engine);
    }

    @Override
    public void setChartEngine(final ChartEngine engine)
    {
        setChartEngineWithoutFiringEvent(engine);
        fireTableStructureChanged();
    }

    @Override
    public int getRowCount()
    {
        return abstractGetRowCount();
    }

    @Override
    public String getColumnName(final int col)
    {
        String baseName = abstractGetColumnName(col);
        if(col >= 0)
        {
            final TimeSeriesArray ts = getTimeSeries(col);
            if(ts != null)
            {
                baseName = baseName.replace("</html>", "<br>" + ts.getHeader().getParameterId() + "</html>");
            }
        }
        return baseName;
    }

    @Override
    protected boolean areAllSeriesXaxisValuesSame()
    {
        return abstractAreAllSeriesXaxisValuesSame();
    }

    @Override
    public Object getRawValueAt(final int modelRow, final int modelColumn)
    {
        return abstractGetRawValueAt(modelRow, modelColumn);
    }

    @Override
    public int computeRowForItem(final int seriesIndex, final int seriesItemNumber)
    {
        //The domain is not shared, so the seriesItemNumber IS the row number.
        return seriesItemNumber;
    }
}
