package ohd.hseb.hefs.mefp.sources.cfsv2;

import java.util.Collection;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.charter.ChartEngine;
import ohd.hseb.charter.datasource.DefaultXYChartDataSource;
import ohd.hseb.charter.panel.ChartEngineTableModel;
import ohd.hseb.charter.panel.DomainSharingTimeSeriesChartEngineTableModel;
import ohd.hseb.hefs.pe.tools.DiagnosticChartBuilder;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.pe.tools.TimeSeriesChartDiagnosticPanel;
import ohd.hseb.hefs.utils.gui.help.HelpFile;

import com.google.common.base.Supplier;

/**
 * The diagnostic panel for CFSv2 monthly data. Note that the {@link #getDataTableClass()} is overridden to use
 * {@link CFSv2MonthlyChartDiagnosticTableModel}.
 * 
 * @author hank.herr
 */
@HelpFile("PDFHELP:helpManual.pdf#GEFSDiagnosticsPanelRef")
public class CFSv2MonthlyDiagnosticPanel extends TimeSeriesChartDiagnosticPanel
{
    private static final long serialVersionUID = 1L;

    private DiagnosticChartBuilder _chartBuilder;

    @SuppressWarnings("unchecked")
    public CFSv2MonthlyDiagnosticPanel(final LocationAndDataTypeIdentifier identifier,
                                       final Collection<TimeSeriesArray> timeSeries)
    {
        super(identifier, timeSeries);
        setDateListDateFormat("CCYY-MM-DD");
        try
        {
            String paramFile;
            if(getIdentifier().isPrecipitationDataType())
            {
                paramFile = "mefppe/diagnostics/cfsv2PrecipitationDisplayDiagnostics.xml";
            }
            else if(getIdentifier().isTemperatureDataType())
            {
                paramFile = "mefppe/diagnostics/cfsv2TemperatureDisplayDiagnostics.xml";
            }
            else
            {
                throw new Exception("Unknown parameter type.");
            }
            _chartBuilder = new DiagnosticChartBuilder(getIdentifier(),
                                                       paramFile,
                                                       CFSv2ForecastSource.SOURCE_ID,
                                                       getAllSeries());
        }
        catch(final Exception e)
        {
            error(e);
        }

        updateChart();
    }

    @Override
    protected boolean hasYearSpinner()
    {
        return true;
    }

    @Override
    protected boolean hasForecastList()
    {
        return true;
    }

    /**
     * CFSv2 monthly plots cannot use the {@link DomainSharingTimeSeriesChartEngineTableModel} because the times of
     * recorded values do not line up on monthly time steps.
     */
    @Override
    protected Supplier<ChartEngineTableModel> buildTableModelSupplier()
    {
        return new Supplier<ChartEngineTableModel>()
        {
            @Override
            public ChartEngineTableModel get()
            {
                return new CFSv2MonthlyChartDiagnosticTableModel();
            }
        };
    }

    @Override
    protected ChartEngine buildChart() throws Exception
    {
        _chartBuilder.setYear(getSelectedYear());
        _chartBuilder.setEmphasizedDates(getSelectedDates());
        if(!_chartBuilder.getParameters()
                         .getTemplateParameters()
                         .getChartDrawingParameters()
                         .getPlotTitle()
                         .getText()
                         .endsWith("Precipitation Amounts Aggregate to Monthly (30-day) Sums"))
        {
            _chartBuilder.getParameters()
                         .getTemplateParameters()
                         .getChartDrawingParameters()
                         .getPlotTitle()
                         .setText(_chartBuilder.getParameters()
                                               .getTemplateParameters()
                                               .getChartDrawingParameters()
                                               .getPlotTitle()
                                               .getText()
                             + "\nPrecipitation Amounts Aggregate to Monthly (30-day) Sums");
        }

        final ChartEngine engine = _chartBuilder.buildChartEngine();

        //Setup the source names for display in a table.
        ((DefaultXYChartDataSource)engine.getDataSources().get(0)).setSourceNameInTable("Emphasized Ensemble Mean");
        ((DefaultXYChartDataSource)engine.getDataSources().get(1)).setSourceNameInTable("Emphasized Members");
        ((DefaultXYChartDataSource)engine.getDataSources().get(2)).setSourceNameInTable("Historical Observed");
        ((DefaultXYChartDataSource)engine.getDataSources().get(3)).setSourceNameInTable("Reforecasts");

        return engine;
    }
}
