package ohd.hseb.hefs.mefp.sources.cfsv2;

import java.io.File;

import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.sources.GriddedPEStepProcessor;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.mefp.sources.MEFPSourceDataHandler;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepOptionsPanel;

public class CFSv2PEStepProcessor extends GriddedPEStepProcessor
{
    public CFSv2PEStepProcessor(final MEFPParameterEstimatorRunInfo runInfo)
    {
        super(runInfo, (MEFPForecastSource)runInfo.getForecastSource(CFSv2ForecastSource.SOURCE_ID));
    }

    @Override
    public ParameterEstimatorStepOptionsPanel constructOptionsPanel()
    {
        return new CFSv2PEStepOptionsPanel(getRunInfo(), this);
    }

    @Override
    protected MEFPSourceDataHandler instantiateSFTPHandler() throws Exception
    {
        return new CFSv2DataHandler(new File(getRunInfo().getGriddedDataSFTPSettings().getBaseDirectoryOnServer()));
    }

}
