package ohd.hseb.hefs.mefp.sources.gefs;

import java.util.Collection;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.charter.ChartEngine;
import ohd.hseb.charter.datasource.DefaultXYChartDataSource;
import ohd.hseb.hefs.pe.tools.DiagnosticChartBuilder;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.pe.tools.TimeSeriesChartDiagnosticPanel;
import ohd.hseb.hefs.utils.gui.help.HelpFile;

/**
 * This diagnostic display is built based on the system resources gfsPrecipitationDisplayDiagnostics.xml and
 * gfsTemperatureDisplayDiagnostics.xml under mefppe/diagnostics. It is a Graphics Generator product whic displays each
 * GEFS forecast time series (prate for precip and tmax/tmin for temp) in a rotating color scheme based on 12 member
 * espadp color palette (blue to cyan to green to yellow to red in 12 steps).<br>
 * <br>
 * To modify the base product, run the GraphGenForDiagnosticsEditingRunner under ohd.hseb.mefp.tools as a java app.
 * Select the product you want to edit under nonsrc/mefppe/diagnostics, and modify it. When done, copy the parameters
 * created and viewed via the Output panel preview button (at the bottom) into the product by hand. Add any needed
 * required arguments to the execute parameter section of the XML.
 * 
 * @author hank.herr
 */
@HelpFile("PDFHELP:helpManual.pdf#GEFSDiagnosticsPanelRef")
@SuppressWarnings("serial")
public class GEFSDiagnosticPanel extends TimeSeriesChartDiagnosticPanel
{
    private DiagnosticChartBuilder _chartBuilder;

    @Override
    protected boolean hasYearSpinner()
    {
        return true;
    }

    @Override
    protected boolean hasForecastList()
    {
        return true;
    }

    @SuppressWarnings("unchecked")
    public GEFSDiagnosticPanel(final LocationAndDataTypeIdentifier identifier,
                               final Collection<TimeSeriesArray> timeSeries)
    {
        super(identifier, timeSeries);

        try
        {
            String paramFile;
            if(getIdentifier().isPrecipitationDataType())
            {
                paramFile = "mefppe/diagnostics/gefsPrecipitationDisplayDiagnostics.xml";
            }
            else if(getIdentifier().isTemperatureDataType())
            {
                paramFile = "mefppe/diagnostics/gefsTemperatureDisplayDiagnostics.xml";
            }
            else
            {
                throw new Exception("Unknown parameter type.");
            }
            _chartBuilder = new DiagnosticChartBuilder(getIdentifier(),
                                                       paramFile,
                                                       GEFSForecastSource.SOURCE_ID,
                                                       getAllSeries());
        }
        catch(final Exception e)
        {
            error(e);
        }

        updateChart();
    }

    @Override
    protected ChartEngine buildChart() throws Exception
    {
        _chartBuilder.setYear(getSelectedYear());
        _chartBuilder.setEmphasizedDates(getSelectedDates());

        final ChartEngine engine = _chartBuilder.buildChartEngine();

        //Setup the source names
        ((DefaultXYChartDataSource)engine.getDataSources().get(0)).setSourceNameInTable("Emphasized Ensemble Mean");
        ((DefaultXYChartDataSource)engine.getDataSources().get(1)).setSourceNameInTable("Historical Observed");
        ((DefaultXYChartDataSource)engine.getDataSources().get(2)).setSourceNameInTable("Reforecasts");

        return engine;
    }
}
