package ohd.hseb.hefs.mefp.sources.gefs;

import java.io.File;

import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.sources.GriddedPEStepProcessor;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.mefp.sources.MEFPSourceDataHandler;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepOptionsPanel;

public class GEFSPEStepProcessor extends GriddedPEStepProcessor
{
    public GEFSPEStepProcessor(final MEFPParameterEstimatorRunInfo runInfo)
    {
        super(runInfo, (MEFPForecastSource)runInfo.getForecastSource(GEFSForecastSource.SOURCE_ID));
    }

    @Override
    public ParameterEstimatorStepOptionsPanel constructOptionsPanel()
    {
        return new GEFSPEStepOptionsPanel(getRunInfo(), this);
    }

    @Override
    protected MEFPSourceDataHandler instantiateSFTPHandler() throws Exception
    {
        return new GEFSDataHandler(new File(getRunInfo().getGriddedDataSFTPSettings().getBaseDirectoryOnServer()));
    }
}
