package ohd.hseb.hefs.mefp.sources.historical;

import java.io.File;

import ohd.hseb.hefs.mefp.models.parameters.MEFPSourceModelParameters;
import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.pe.estimation.GenericMEFPSourceControlOptions;
import ohd.hseb.hefs.mefp.pe.estimation.MEFPPrecipitationSourceControlOptions;
import ohd.hseb.hefs.mefp.sources.AbstractMEFPForecastSource;
import ohd.hseb.hefs.mefp.sources.MEFPSourceControlOptions;
import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.model.AlgorithmModelParameters;
import ohd.hseb.hefs.pe.sources.SourceDataHandler;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.notify.NoticePoster;
import ohd.hseb.hefs.utils.tools.ParameterId;

public class HistoricalForecastSource extends AbstractMEFPForecastSource
{
    /**
     * This ===MUST=== match the portion of the source name before 'ForecastSource', so that it matches the default
     * return of {@link #getSourceId()}.
     */
    public static final String SOURCE_ID = "Historical";

    @Override
    public String getName()
    {
        return "Historical Data (Climatology)";
    }

    @Override
    public MEFPSourceModelParameters getSourceModelParameters(final LocationAndDataTypeIdentifier identifier,
                                                              final AlgorithmModelParameters algorithmParameters)
    {
        final HistoricalSourceModelParameters parameters = new HistoricalSourceModelParameters(identifier,
                                                                                               this,
                                                                                               algorithmParameters);
        return parameters;
    }

    @Override
    public HistoricalDataHandler getSourceDataHandler()
    {
        return (HistoricalDataHandler)super.getSourceDataHandler();
    }

    @Override
    protected void setSourceDataHandler(final SourceDataHandler handler)
    {
        if(!(handler instanceof HistoricalDataHandler))
        {
            throw new IllegalArgumentException("The SourceDataHandler is not a HistoricalDataHandler.");
        }
        super.setSourceDataHandler(handler);
    }

    @Override
    public MEFPSourceControlOptions createControlOptions(final ParameterId.Type type)
    {
        switch(type)
        {
            case TEMPERATURE:
                return new GenericMEFPSourceControlOptions("climateTemperatureControlOptions", this);
            case PRECIPITATION:
                return new MEFPPrecipitationSourceControlOptions("climatePrecipitationControlOptions", this);
            default:
                throw new IllegalArgumentException(String.format("%s not supported.", type));
        }
    }

    @Override
    public void initializeSourceDataHandler(final File baseDirectory, final NoticePoster poster) throws Exception
    {
        this.setSourceDataHandler(new HistoricalDataHandler(baseDirectory, poster));
    }

    @Override
    public boolean canEPTModelBeUsedForSource()
    {
        //Climatology does not allow for the EPT model to be used with it.
// LW        return false;
        return true;
    }

    @Override
    public boolean isClimatologySource()
    {
        return true;
    }

    @Override
    public ParameterEstimatorStepProcessor getSourceStepProcessor(final ParameterEstimatorRunInfo runInfo)
    {
        return new HistoricalPEStepProcessor((MEFPParameterEstimatorRunInfo)runInfo);
    }
}
